/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.client.gui.element.panel;

import cofh.core.client.gui.CoreTextures;
import cofh.core.client.gui.IGuiAccess;
import cofh.core.client.gui.element.panel.PanelBase;
import cofh.lib.util.control.IRedstoneControllable;
import cofh.lib.util.helpers.RenderHelper;
import cofh.lib.util.helpers.SoundHelper;
import cofh.lib.util.helpers.StringHelper;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class PanelRedstoneControl
extends PanelBase {
    public static int defaultSide = 1;
    public static int defaultHeaderColor = 14797103;
    public static int defaultSubHeaderColor = 11186104;
    public static int defaultTextColor = 0;
    public static int defaultBackgroundColor = 13640458;
    private IRedstoneControllable myRSControllable;

    public PanelRedstoneControl(IGuiAccess gui, IRedstoneControllable rsControllable) {
        this(gui, defaultSide, rsControllable);
    }

    public PanelRedstoneControl(IGuiAccess gui, int side, IRedstoneControllable rsControllable) {
        super(gui, side);
        this.headerColor = defaultHeaderColor;
        this.subheaderColor = defaultSubHeaderColor;
        this.textColor = defaultTextColor;
        this.backgroundColor = defaultBackgroundColor;
        this.maxHeight = 92;
        this.maxWidth = 112;
        this.myRSControllable = rsControllable;
        this.setVisible(this.myRSControllable::isControllable);
    }

    @Override
    protected void drawForeground() {
        this.drawPanelIcon(CoreTextures.ICON_REDSTONE_ON);
        if (!this.fullyOpen) {
            return;
        }
        this.getFontRenderer().func_175063_a(StringHelper.localize("info.cofh.redstone_control"), (float)(this.sideOffset() + 18), 6.0f, this.headerColor);
        this.getFontRenderer().func_175063_a(StringHelper.localize("info.cofh.control_status") + ":", (float)(this.sideOffset() + 6), 42.0f, this.subheaderColor);
        this.getFontRenderer().func_175063_a(StringHelper.localize("info.cofh.signal_required") + ":", (float)(this.sideOffset() + 6), 66.0f, this.subheaderColor);
        this.gui.drawIcon(CoreTextures.ICON_BUTTON, 28, 20);
        this.gui.drawIcon(CoreTextures.ICON_BUTTON, 48, 20);
        this.gui.drawIcon(CoreTextures.ICON_BUTTON, 68, 20);
        switch (this.myRSControllable.getMode()) {
            case DISABLED: {
                this.gui.drawIcon(CoreTextures.ICON_BUTTON_HIGHLIGHT, 28, 20);
                this.getFontRenderer().func_211126_b(StringHelper.localize("info.cofh.disabled"), (float)(this.sideOffset() + 14), 54.0f, this.textColor);
                this.getFontRenderer().func_211126_b(StringHelper.localize("info.cofh.ignored"), (float)(this.sideOffset() + 14), 78.0f, this.textColor);
                break;
            }
            case LOW: {
                this.gui.drawIcon(CoreTextures.ICON_BUTTON_HIGHLIGHT, 48, 20);
                this.getFontRenderer().func_211126_b(StringHelper.localize("info.cofh.enabled"), (float)(this.sideOffset() + 14), 54.0f, this.textColor);
                this.getFontRenderer().func_211126_b(StringHelper.localize("info.cofh.low"), (float)(this.sideOffset() + 14), 78.0f, this.textColor);
                break;
            }
            case HIGH: {
                this.gui.drawIcon(CoreTextures.ICON_BUTTON_HIGHLIGHT, 68, 20);
                this.getFontRenderer().func_211126_b(StringHelper.localize("info.cofh.enabled"), (float)(this.sideOffset() + 14), 54.0f, this.textColor);
                this.getFontRenderer().func_211126_b(StringHelper.localize("info.cofh.high"), (float)(this.sideOffset() + 14), 78.0f, this.textColor);
                break;
            }
        }
        this.gui.drawIcon(CoreTextures.ICON_REDSTONE_OFF, 28, 20);
        this.gui.drawIcon(CoreTextures.ICON_RS_TORCH_OFF, 48, 20);
        this.gui.drawIcon(CoreTextures.ICON_RS_TORCH_ON, 68, 20);
        RenderHelper.resetColor();
    }

    @Override
    protected void drawBackground() {
        super.drawBackground();
        if (!this.fullyOpen) {
            return;
        }
        float colorR = (float)(this.backgroundColor >> 16 & 0xFF) / 255.0f * 0.6f;
        float colorG = (float)(this.backgroundColor >> 8 & 0xFF) / 255.0f * 0.6f;
        float colorB = (float)(this.backgroundColor & 0xFF) / 255.0f * 0.6f;
        RenderSystem.color4f((float)colorR, (float)colorG, (float)colorB, (float)1.0f);
        this.gui.drawTexturedModalRect(24, 16, 16, 20, 64, 24);
        RenderHelper.resetColor();
    }

    @Override
    public void addTooltip(List<ITextComponent> tooltipList, int mouseX, int mouseY) {
        if (!this.fullyOpen) {
            tooltipList.add((ITextComponent)new TranslationTextComponent("info.cofh.redstone_control", new Object[0]));
            switch (this.myRSControllable.getMode()) {
                case DISABLED: {
                    tooltipList.add(new TranslationTextComponent("info.cofh.disabled", new Object[0]).func_211708_a(TextFormatting.YELLOW));
                    break;
                }
                case LOW: {
                    tooltipList.add(new TranslationTextComponent("info.cofh.low", new Object[0]).func_211708_a(TextFormatting.YELLOW));
                    break;
                }
                case HIGH: {
                    tooltipList.add(new TranslationTextComponent("info.cofh.high", new Object[0]).func_211708_a(TextFormatting.YELLOW));
                    break;
                }
            }
            return;
        }
        int x = mouseX - this.posX();
        int y = mouseY - this.posY;
        if (28 <= x && x < 44 && 20 <= y && y < 36) {
            tooltipList.add((ITextComponent)new TranslationTextComponent("info.cofh.ignored", new Object[0]));
        } else if (48 <= x && x < 64 && 20 <= y && y < 36) {
            tooltipList.add((ITextComponent)new TranslationTextComponent("info.cofh.low", new Object[0]));
        } else if (68 <= x && x < 84 && 20 <= y && y < 36) {
            tooltipList.add((ITextComponent)new TranslationTextComponent("info.cofh.high", new Object[0]));
        }
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (!this.fullyOpen) {
            return false;
        }
        double x = mouseX - (double)this.posX();
        double y = mouseY - (double)this.posY;
        if (x < 24.0 || x >= 88.0 || y < 16.0 || y >= 40.0) {
            return false;
        }
        if (28.0 <= x && x < 44.0 && 20.0 <= y && y < 36.0) {
            if (this.myRSControllable.getMode() != IRedstoneControllable.ControlMode.DISABLED) {
                this.myRSControllable.setControl(0, IRedstoneControllable.ControlMode.DISABLED);
                SoundHelper.playClickSound(0.4f);
            }
        } else if (48.0 <= x && x < 64.0 && 20.0 <= y && y < 36.0) {
            if (this.myRSControllable.getMode() != IRedstoneControllable.ControlMode.LOW) {
                this.myRSControllable.setControl(0, IRedstoneControllable.ControlMode.LOW);
                SoundHelper.playClickSound(0.6f);
            }
        } else if (68.0 <= x && x < 84.0 && 20.0 <= y && y < 36.0 && this.myRSControllable.getMode() != IRedstoneControllable.ControlMode.HIGH) {
            this.myRSControllable.setControl(0, IRedstoneControllable.ControlMode.HIGH);
            SoundHelper.playClickSound(0.8f);
        }
        return true;
    }
}

