/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.block;

import cofh.lib.util.helpers.MathHelper;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.MagmaBlock;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class GlossedMagmaBlock
extends MagmaBlock {
    public static final IntegerProperty AGE = IntegerProperty.func_177719_a((String)"age", (int)0, (int)3);

    public GlossedMagmaBlock(Block.Properties builder) {
        super(builder);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)AGE, (Comparable)Integer.valueOf(0)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{AGE});
    }

    public void func_180657_a(World worldIn, PlayerEntity player, BlockPos pos, BlockState state, @Nullable TileEntity te, ItemStack stack) {
        Material material;
        super.func_180657_a(worldIn, player, pos, state, te, stack);
        if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)stack) == 0 && ((material = worldIn.func_180495_p(pos.func_177977_b()).func_185904_a()).func_76230_c() || material.func_76224_d())) {
            worldIn.func_175656_a(pos, Blocks.field_150353_l.func_176223_P());
        }
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (blockIn == this && this.shouldMelt((IBlockReader)worldIn, pos, 2)) {
            this.turnIntoLava(state, worldIn, pos);
        }
        super.func_220069_a(state, worldIn, pos, blockIn, fromPos, isMoving);
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        if ((random.nextInt(9) == 0 || this.shouldMelt((IBlockReader)worldIn, pos, 4)) && this.slightlyMelt(state, (World)worldIn, pos)) {
            try (BlockPos.PooledMutable mutable = BlockPos.PooledMutable.func_185346_s();){
                for (Direction direction : Direction.values()) {
                    mutable.func_189533_g((Vec3i)pos).func_189536_c(direction);
                    BlockState blockstate = worldIn.func_180495_p((BlockPos)mutable);
                    if (blockstate.func_177230_c() != this || this.slightlyMelt(blockstate, (World)worldIn, (BlockPos)mutable)) continue;
                    worldIn.func_205220_G_().func_205360_a((BlockPos)mutable, (Object)this, MathHelper.nextInt(random, 20, 40));
                }
            }
        } else {
            worldIn.func_205220_G_().func_205360_a(pos, (Object)this, MathHelper.nextInt(random, 20, 40));
        }
    }

    public ItemStack func_185473_a(IBlockReader worldIn, BlockPos pos, BlockState state) {
        return ItemStack.field_190927_a;
    }

    protected void turnIntoLava(BlockState state, World worldIn, BlockPos pos) {
        worldIn.func_175656_a(pos, Blocks.field_150353_l.func_176223_P());
        worldIn.func_190524_a(pos, Blocks.field_150353_l, pos);
    }

    protected boolean shouldMelt(IBlockReader worldIn, BlockPos pos, int neighborsRequired) {
        int i = 0;
        try (BlockPos.PooledMutable mutable = BlockPos.PooledMutable.func_185346_s();){
            for (Direction direction : Direction.values()) {
                mutable.func_189533_g((Vec3i)pos).func_189536_c(direction);
                if (worldIn.func_180495_p((BlockPos)mutable).func_177230_c() != this || ++i < neighborsRequired) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
    }

    protected boolean slightlyMelt(BlockState state, World worldIn, BlockPos pos) {
        int i = (Integer)state.func_177229_b((IProperty)AGE);
        if (i < 3) {
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)AGE, (Comparable)Integer.valueOf(i + 1)), 2);
            return false;
        }
        this.turnIntoLava(state, worldIn, pos);
        return true;
    }
}

