/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.item.boomerang;

import com.lothrazar.cyclic.base.ItemBase;
import com.lothrazar.cyclic.item.boomerang.BoomerangEntity;
import com.lothrazar.cyclic.item.boomerang.BoomerangEntityCarry;
import com.lothrazar.cyclic.item.boomerang.BoomerangEntityDamage;
import com.lothrazar.cyclic.item.boomerang.BoomerangEntityStun;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BowItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.world.World;

public class BoomerangItem
extends ItemBase {
    private static final float INACCURACY_DEFAULT = 1.0f;
    private static final float PITCHOFFSET = 0.0f;
    private static final float VELOCITY_MAX = 1.5f;
    private static final int TICKS_USING = 93000;
    private Boomer type;

    public BoomerangItem(Boomer type, Item.Properties properties) {
        super(properties);
        this.type = type;
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.BOW;
    }

    public int func_77626_a(ItemStack stack) {
        return 93000;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        playerIn.func_184598_c(handIn);
        return new ActionResult(ActionResultType.SUCCESS, (Object)itemstack);
    }

    public void func_77615_a(ItemStack stack, World worldIn, LivingEntity entity, int chargeTimer) {
        BoomerangEntity e;
        int charge = this.func_77626_a(stack) - chargeTimer;
        float percentageCharged = BowItem.func_185059_b((int)charge);
        if ((double)percentageCharged < 0.1) {
            return;
        }
        float velocityFactor = percentageCharged * 1.5f;
        if (!(entity instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)entity;
        switch (this.type) {
            case CARRY: {
                e = new BoomerangEntityCarry(worldIn, (LivingEntity)player);
                break;
            }
            case DAMAGE: {
                e = new BoomerangEntityDamage(worldIn, (LivingEntity)player);
                break;
            }
            default: {
                e = new BoomerangEntityStun(worldIn, (LivingEntity)player);
            }
        }
        e.func_184538_a((Entity)entity, player.field_70125_A, player.field_70177_z, 0.0f, velocityFactor * 1.5f, 1.0f);
        worldIn.func_217376_c((Entity)e);
        stack.func_222118_a(1, (LivingEntity)player, p -> p.func_213334_d(Hand.MAIN_HAND));
        player.func_184611_a(player.func_184600_cs(), ItemStack.field_190927_a);
        e.setBoomerangThrown(stack.func_77946_l());
        e.setOwner(player);
    }

    public static enum Boomer {
        STUN,
        DAMAGE,
        CARRY;

    }
}

