/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.nio.file.Path;
import net.minecraftforge.common.ForgeConfigSpec;

public class ConfigManager {
    private static final ForgeConfigSpec.Builder COMMON_BUILDER = new ForgeConfigSpec.Builder();
    private static ForgeConfigSpec COMMON_CONFIG;
    public static ForgeConfigSpec.BooleanValue EMERALD;
    public static ForgeConfigSpec.BooleanValue SANDSTONE;
    public static ForgeConfigSpec.BooleanValue GEMGEAR;
    public static ForgeConfigSpec.BooleanValue NETHERBRICK;
    public static ForgeConfigSpec.BooleanValue ENCHANTMENTS;
    public static ForgeConfigSpec.IntValue ANVILPOWER;
    public static ForgeConfigSpec.IntValue MELTERPOWER;
    public static ForgeConfigSpec.IntValue SOLIDIFIERPOWER;
    public static ForgeConfigSpec.DoubleValue PEATCHANCE;
    public static ForgeConfigSpec.IntValue PEATERICHPOWER;
    public static ForgeConfigSpec.IntValue PEATPOWER;
    public static ForgeConfigSpec.BooleanValue CHARMS;
    public static ForgeConfigSpec.BooleanValue GLOVE;
    public static ForgeConfigSpec.BooleanValue HEARTS;
    public static ForgeConfigSpec.BooleanValue CARROTS;

    private static void initConfig() {
        COMMON_BUILDER.comment("Feature toggles; each of these will disable the registration of some content (items/enchants)").push("cyclic");
        CARROTS = COMMON_BUILDER.comment("Disable the 5 carrot items that upgrade horses").define("carrots", true);
        HEARTS = COMMON_BUILDER.comment("Disable 2 heart items that increase and decrease max health").define("hearts", true);
        GLOVE = COMMON_BUILDER.comment("Disable the completely balanced climbing glove").define("glove", true);
        CHARMS = COMMON_BUILDER.comment("Disable 6 charms (four basic, the ultimate, and the anti-gravity)").define("charms", true);
        EMERALD = COMMON_BUILDER.comment("Disable 9 items, emerald armor and tools").define("emeraldGear", true);
        SANDSTONE = COMMON_BUILDER.comment("Disable 5 sandstone tools").define("sandstoneGear", true);
        GEMGEAR = COMMON_BUILDER.comment("Disable the endgame gear").define("gemObsidianGear", true);
        NETHERBRICK = COMMON_BUILDER.comment("Disable 5 netherbrick tools").define("netherbrickGear", true);
        ENCHANTMENTS = COMMON_BUILDER.comment("Disable all 11 enchantments").define("enchantments", true);
        PEATPOWER = COMMON_BUILDER.comment("Power to repair one tick of durability").defineInRange("energy.fuel.peat_fuel", 256, 1, 64000);
        PEATERICHPOWER = COMMON_BUILDER.comment("Power gained burning one of this").defineInRange("energy.fuel.peat_fuel_enriched", 1024, 1, 64000);
        ANVILPOWER = COMMON_BUILDER.comment("Power gained burning one of this").defineInRange("energy.cost.anvil", 250, 1, 64000);
        MELTERPOWER = COMMON_BUILDER.comment("Power per recipe").defineInRange("energy.cost.melter", 5000, 1, 64000);
        SOLIDIFIERPOWER = COMMON_BUILDER.comment("Power per recipe").defineInRange("energy.cost.solidifier", 5000, 1, 64000);
        PEATCHANCE = COMMON_BUILDER.comment("Chance that Peat Bog converts to Peat when wet (is multiplied by the number of surrounding water blocks)").defineInRange("peat.conversionChance", (double)0.08f, (double)0.001f, 1.0);
        COMMON_BUILDER.pop();
        COMMON_CONFIG = COMMON_BUILDER.build();
    }

    public ConfigManager(Path path) {
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)path).sync().autosave().writingMode(WritingMode.REPLACE).build();
        configData.load();
        COMMON_CONFIG.setConfig((CommentedConfig)configData);
    }

    static {
        ConfigManager.initConfig();
    }
}

