/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.storage.loot.functions;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootFunction;
import net.minecraft.world.storage.loot.LootParameter;
import net.minecraft.world.storage.loot.LootParameters;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.ILootCondition;
import net.minecraft.world.storage.loot.functions.ILootFunction;

public class LootingEnchantBonus
extends LootFunction {
    private final RandomValueRange field_186563_a;
    private final int field_189971_b;

    private LootingEnchantBonus(ILootCondition[] conditions, RandomValueRange countIn, int limitIn) {
        super(conditions);
        this.field_186563_a = countIn;
        this.field_189971_b = limitIn;
    }

    public Set<LootParameter<?>> func_215855_a() {
        return ImmutableSet.of((Object)LootParameters.field_216284_d);
    }

    private boolean func_215917_b() {
        return this.field_189971_b > 0;
    }

    public ItemStack func_215859_a(ItemStack stack, LootContext context) {
        Entity entity = (Entity)((Object)context.func_216031_c(LootParameters.field_216284_d));
        if (entity instanceof LivingEntity) {
            int i = context.getLootingModifier();
            if (i == 0) {
                return stack;
            }
            float f = (float)i * this.field_186563_a.func_186507_b(context.func_216032_b());
            stack.func_190917_f(Math.round(f));
            if (this.func_215917_b() && stack.func_190916_E() > this.field_189971_b) {
                stack.func_190920_e(this.field_189971_b);
            }
        }
        return stack;
    }

    public static Builder func_215915_a(RandomValueRange range) {
        return new Builder(range);
    }

    public static class Serializer
    extends LootFunction.Serializer<LootingEnchantBonus> {
        protected Serializer() {
            super(new ResourceLocation("looting_enchant"), LootingEnchantBonus.class);
        }

        public void func_186532_a(JsonObject object, LootingEnchantBonus functionClazz, JsonSerializationContext serializationContext) {
            super.func_186532_a(object, (LootFunction)functionClazz, serializationContext);
            object.add("count", serializationContext.serialize((Object)functionClazz.field_186563_a));
            if (functionClazz.func_215917_b()) {
                object.add("limit", serializationContext.serialize((Object)functionClazz.field_189971_b));
            }
        }

        public LootingEnchantBonus func_186530_b(JsonObject object, JsonDeserializationContext deserializationContext, ILootCondition[] conditionsIn) {
            int i = JSONUtils.func_151208_a((JsonObject)object, (String)"limit", (int)0);
            return new LootingEnchantBonus(conditionsIn, (RandomValueRange)JSONUtils.func_188174_a((JsonObject)object, (String)"count", (JsonDeserializationContext)deserializationContext, RandomValueRange.class), i);
        }
    }

    public static class Builder
    extends LootFunction.Builder<Builder> {
        private final RandomValueRange field_216073_a;
        private int field_216074_b = 0;

        public Builder(RandomValueRange p_i50932_1_) {
            this.field_216073_a = p_i50932_1_;
        }

        protected Builder func_212826_d_() {
            return this;
        }

        public Builder func_216072_a(int p_216072_1_) {
            this.field_216074_b = p_216072_1_;
            return this;
        }

        public ILootFunction func_216052_b() {
            return new LootingEnchantBonus(this.func_216053_g(), this.field_216073_a, this.field_216074_b);
        }
    }
}

