/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature;

import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityType;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.tileentity.MobSpawnerTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.storage.loot.LootTables;
import net.minecraftforge.common.DungeonHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DungeonsFeature
extends Feature<NoFeatureConfig> {
    private static final Logger field_175918_a = LogManager.getLogger();
    private static final EntityType<?>[] field_175916_b = new EntityType[]{EntityType.field_200741_ag, EntityType.field_200725_aD, EntityType.field_200725_aD, EntityType.field_200748_an};
    private static final BlockState field_205189_c = Blocks.field_201941_jj.func_176223_P();

    public DungeonsFeature(Function<Dynamic<?>, ? extends NoFeatureConfig> p_i51477_1_) {
        super(p_i51477_1_);
    }

    @Override
    public boolean func_212245_a(IWorld worldIn, ChunkGenerator<? extends GenerationSettings> generator, Random rand, BlockPos pos, NoFeatureConfig config) {
        int i = 3;
        int j = rand.nextInt(2) + 2;
        int k = -j - 1;
        int l = j + 1;
        int i1 = -1;
        int j1 = 4;
        int k1 = rand.nextInt(2) + 2;
        int l1 = -k1 - 1;
        int i2 = k1 + 1;
        int j2 = 0;
        for (int k2 = k; k2 <= l; ++k2) {
            for (int l2 = -1; l2 <= 4; ++l2) {
                for (int i3 = l1; i3 <= i2; ++i3) {
                    BlockPos blockpos = pos.func_177982_a(k2, l2, i3);
                    Material material = worldIn.func_180495_p(blockpos).func_185904_a();
                    boolean flag = material.func_76220_a();
                    if (l2 == -1 && !flag) {
                        return false;
                    }
                    if (l2 == 4 && !flag) {
                        return false;
                    }
                    if (k2 != k && k2 != l && i3 != l1 && i3 != i2 || l2 != 0 || !worldIn.func_175623_d(blockpos) || !worldIn.func_175623_d(blockpos.func_177984_a())) continue;
                    ++j2;
                }
            }
        }
        if (j2 >= 1 && j2 <= 5) {
            for (int k3 = k; k3 <= l; ++k3) {
                for (int i4 = 3; i4 >= -1; --i4) {
                    for (int k4 = l1; k4 <= i2; ++k4) {
                        BlockPos blockpos1 = pos.func_177982_a(k3, i4, k4);
                        if (k3 != k && i4 != -1 && k4 != l1 && k3 != l && i4 != 4 && k4 != i2) {
                            if (worldIn.func_180495_p(blockpos1).func_177230_c() == Blocks.field_150486_ae) continue;
                            worldIn.func_180501_a(blockpos1, field_205189_c, 2);
                            continue;
                        }
                        if (blockpos1.func_177956_o() >= 0 && !worldIn.func_180495_p(blockpos1.func_177977_b()).func_185904_a().func_76220_a()) {
                            worldIn.func_180501_a(blockpos1, field_205189_c, 2);
                            continue;
                        }
                        if (!worldIn.func_180495_p(blockpos1).func_185904_a().func_76220_a() || worldIn.func_180495_p(blockpos1).func_177230_c() == Blocks.field_150486_ae) continue;
                        if (i4 == -1 && rand.nextInt(4) != 0) {
                            worldIn.func_180501_a(blockpos1, Blocks.field_150341_Y.func_176223_P(), 2);
                            continue;
                        }
                        worldIn.func_180501_a(blockpos1, Blocks.field_150347_e.func_176223_P(), 2);
                    }
                }
            }
            block6: for (int l3 = 0; l3 < 2; ++l3) {
                for (int j4 = 0; j4 < 3; ++j4) {
                    int j5;
                    int i5;
                    int l4 = pos.func_177958_n() + rand.nextInt(j * 2 + 1) - j;
                    BlockPos blockpos2 = new BlockPos(l4, i5 = pos.func_177956_o(), j5 = pos.func_177952_p() + rand.nextInt(k1 * 2 + 1) - k1);
                    if (!worldIn.func_175623_d(blockpos2)) continue;
                    int j3 = 0;
                    for (Direction direction : Direction.Plane.HORIZONTAL) {
                        if (!worldIn.func_180495_p(blockpos2.func_177972_a(direction)).func_185904_a().func_76220_a()) continue;
                        ++j3;
                    }
                    if (j3 != true) continue;
                    worldIn.func_180501_a(blockpos2, StructurePiece.func_197528_a((IBlockReader)((Object)worldIn), blockpos2, Blocks.field_150486_ae.func_176223_P()), 2);
                    LockableLootTileEntity.func_195479_a((IBlockReader)((Object)worldIn), (Random)rand, (BlockPos)blockpos2, (ResourceLocation)LootTables.field_186422_d);
                    continue block6;
                }
            }
            worldIn.func_180501_a(pos, Blocks.field_150474_ac.func_176223_P(), 2);
            TileEntity tileentity = worldIn.func_175625_s(pos);
            if (tileentity instanceof MobSpawnerTileEntity) {
                ((MobSpawnerTileEntity)tileentity).func_145881_a().func_200876_a(this.func_201043_a(rand));
            } else {
                field_175918_a.error("Failed to fetch mob spawner entity at ({}, {}, {})", (Object)pos.func_177958_n(), (Object)pos.func_177956_o(), (Object)pos.func_177952_p());
            }
            return true;
        }
        return false;
    }

    private EntityType<?> func_201043_a(Random rand) {
        return DungeonHooks.getRandomDungeonMob((Random)rand);
    }
}

