/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeMap;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.FilledMapItem;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.server.SEntityEquipmentPacket;
import net.minecraft.network.play.server.SEntityHeadLookPacket;
import net.minecraft.network.play.server.SEntityMetadataPacket;
import net.minecraft.network.play.server.SEntityPacket;
import net.minecraft.network.play.server.SEntityPropertiesPacket;
import net.minecraft.network.play.server.SEntityTeleportPacket;
import net.minecraft.network.play.server.SEntityVelocityPacket;
import net.minecraft.network.play.server.SMountEntityPacket;
import net.minecraft.network.play.server.SPlayEntityEffectPacket;
import net.minecraft.network.play.server.SSetPassengersPacket;
import net.minecraft.network.play.server.SSpawnMobPacket;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.MapData;
import net.minecraftforge.event.ForgeEventFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TrackedEntity {
    private static final Logger field_219459_a = LogManager.getLogger();
    private final ServerWorld field_219460_b;
    private final Entity field_219461_c;
    private final int field_219462_d;
    private final boolean field_219463_e;
    private final Consumer<IPacket<?>> field_219464_f;
    private long field_219465_g;
    private long field_219466_h;
    private long field_219467_i;
    private int field_219468_j;
    private int field_219469_k;
    private int field_219470_l;
    private Vec3d field_219471_m = Vec3d.field_186680_a;
    private int field_219472_n;
    private int field_219473_o;
    private List<Entity> field_219474_p = Collections.emptyList();
    private boolean field_219475_q;
    private boolean field_219476_r;

    public TrackedEntity(ServerWorld p_i50704_1_, Entity p_i50704_2_, int p_i50704_3_, boolean p_i50704_4_, Consumer<IPacket<?>> p_i50704_5_) {
        this.field_219460_b = p_i50704_1_;
        this.field_219464_f = p_i50704_5_;
        this.field_219461_c = p_i50704_2_;
        this.field_219462_d = p_i50704_3_;
        this.field_219463_e = p_i50704_4_;
        this.func_219458_d();
        this.field_219468_j = MathHelper.func_76141_d((float)(p_i50704_2_.field_70177_z * 256.0f / 360.0f));
        this.field_219469_k = MathHelper.func_76141_d((float)(p_i50704_2_.field_70125_A * 256.0f / 360.0f));
        this.field_219470_l = MathHelper.func_76141_d((float)(p_i50704_2_.func_70079_am() * 256.0f / 360.0f));
        this.field_219476_r = p_i50704_2_.field_70122_E;
    }

    public void func_219453_a() {
        List<Entity> list = this.field_219461_c.func_184188_bt();
        if (!list.equals(this.field_219474_p)) {
            this.field_219474_p = list;
            this.field_219464_f.accept((IPacket<?>)new SSetPassengersPacket(this.field_219461_c));
        }
        if (this.field_219461_c instanceof ItemFrameEntity && this.field_219472_n % 10 == 0) {
            ItemFrameEntity itemframeentity = (ItemFrameEntity)this.field_219461_c;
            ItemStack itemstack = itemframeentity.func_82335_i();
            MapData mapdata = FilledMapItem.func_195950_a(itemstack, this.field_219460_b);
            if (mapdata != null) {
                for (ServerPlayerEntity serverplayerentity : this.field_219460_b.func_217369_A()) {
                    mapdata.func_76191_a(serverplayerentity, itemstack);
                    IPacket<?> ipacket = ((FilledMapItem)((Object)itemstack.func_77973_b())).func_150911_c(itemstack, this.field_219460_b, serverplayerentity);
                    if (ipacket == null) continue;
                    serverplayerentity.field_71135_a.func_147359_a(ipacket);
                }
            }
            this.func_219457_c();
        }
        if (this.field_219472_n % this.field_219462_d == 0 || this.field_219461_c.field_70160_al || this.field_219461_c.func_184212_Q().func_187223_a()) {
            if (this.field_219461_c.func_184218_aH()) {
                boolean flag2;
                int i1 = MathHelper.func_76141_d((float)(this.field_219461_c.field_70177_z * 256.0f / 360.0f));
                int l1 = MathHelper.func_76141_d((float)(this.field_219461_c.field_70125_A * 256.0f / 360.0f));
                boolean bl = flag2 = Math.abs(i1 - this.field_219468_j) >= 1 || Math.abs(l1 - this.field_219469_k) >= 1;
                if (flag2) {
                    this.field_219464_f.accept((IPacket<?>)new SEntityPacket.LookPacket(this.field_219461_c.func_145782_y(), (byte)i1, (byte)l1, this.field_219461_c.field_70122_E));
                    this.field_219468_j = i1;
                    this.field_219469_k = l1;
                }
                this.func_219458_d();
                this.func_219457_c();
                this.field_219475_q = true;
            } else {
                Vec3d vec3d1;
                double d0;
                boolean flag;
                ++this.field_219473_o;
                int l = MathHelper.func_76141_d((float)(this.field_219461_c.field_70177_z * 256.0f / 360.0f));
                int k1 = MathHelper.func_76141_d((float)(this.field_219461_c.field_70125_A * 256.0f / 360.0f));
                Vec3d vec3d = this.field_219461_c.func_213303_ch().func_178788_d(SEntityPacket.func_218744_a((long)this.field_219465_g, (long)this.field_219466_h, (long)this.field_219467_i));
                boolean flag3 = vec3d.func_189985_c() >= 7.62939453125E-6;
                SEntityTeleportPacket ipacket1 = null;
                boolean flag4 = flag3 || this.field_219472_n % 60 == 0;
                boolean bl = flag = Math.abs(l - this.field_219468_j) >= 1 || Math.abs(k1 - this.field_219469_k) >= 1;
                if (this.field_219472_n > 0 || this.field_219461_c instanceof AbstractArrowEntity) {
                    boolean flag1;
                    long i = SEntityPacket.func_218743_a((double)vec3d.field_72450_a);
                    long j = SEntityPacket.func_218743_a((double)vec3d.field_72448_b);
                    long k = SEntityPacket.func_218743_a((double)vec3d.field_72449_c);
                    boolean bl2 = flag1 = i < -32768L || i > 32767L || j < -32768L || j > 32767L || k < -32768L || k > 32767L;
                    if (!flag1 && this.field_219473_o <= 400 && !this.field_219475_q && this.field_219476_r == this.field_219461_c.field_70122_E) {
                        if (!(flag4 && flag || this.field_219461_c instanceof AbstractArrowEntity)) {
                            if (flag4) {
                                ipacket1 = new SEntityPacket.RelativeMovePacket(this.field_219461_c.func_145782_y(), (short)i, (short)j, (short)k, this.field_219461_c.field_70122_E);
                            } else if (flag) {
                                ipacket1 = new SEntityPacket.LookPacket(this.field_219461_c.func_145782_y(), (byte)l, (byte)k1, this.field_219461_c.field_70122_E);
                            }
                        } else {
                            ipacket1 = new SEntityPacket.MovePacket(this.field_219461_c.func_145782_y(), (short)i, (short)j, (short)k, (byte)l, (byte)k1, this.field_219461_c.field_70122_E);
                        }
                    } else {
                        this.field_219476_r = this.field_219461_c.field_70122_E;
                        this.field_219473_o = 0;
                        ipacket1 = new SEntityTeleportPacket(this.field_219461_c);
                    }
                }
                if ((this.field_219463_e || this.field_219461_c.field_70160_al || this.field_219461_c instanceof LivingEntity && ((LivingEntity)this.field_219461_c).func_184613_cA()) && this.field_219472_n > 0 && ((d0 = (vec3d1 = this.field_219461_c.func_213322_ci()).func_72436_e(this.field_219471_m)) > 1.0E-7 || d0 > 0.0 && vec3d1.func_189985_c() == 0.0)) {
                    this.field_219471_m = vec3d1;
                    this.field_219464_f.accept((IPacket<?>)new SEntityVelocityPacket(this.field_219461_c.func_145782_y(), this.field_219471_m));
                }
                if (ipacket1 != null) {
                    this.field_219464_f.accept((IPacket<?>)ipacket1);
                }
                this.func_219457_c();
                if (flag4) {
                    this.func_219458_d();
                }
                if (flag) {
                    this.field_219468_j = l;
                    this.field_219469_k = k1;
                }
                this.field_219475_q = false;
            }
            int j1 = MathHelper.func_76141_d((float)(this.field_219461_c.func_70079_am() * 256.0f / 360.0f));
            if (Math.abs(j1 - this.field_219470_l) >= 1) {
                this.field_219464_f.accept((IPacket<?>)new SEntityHeadLookPacket(this.field_219461_c, (byte)j1));
                this.field_219470_l = j1;
            }
            this.field_219461_c.field_70160_al = false;
        }
        ++this.field_219472_n;
        if (this.field_219461_c.field_70133_I) {
            this.func_219451_a((IPacket<?>)new SEntityVelocityPacket(this.field_219461_c));
            this.field_219461_c.field_70133_I = false;
        }
    }

    public void func_219454_a(ServerPlayerEntity player) {
        this.field_219461_c.func_184203_c(player);
        player.func_152339_d(this.field_219461_c);
        ForgeEventFactory.onStopEntityTracking((Entity)this.field_219461_c, (PlayerEntity)player);
    }

    public void func_219455_b(ServerPlayerEntity player) {
        this.func_219452_a(player.field_71135_a::func_147359_a);
        this.field_219461_c.func_184178_b(player);
        player.func_184848_d(this.field_219461_c);
        ForgeEventFactory.onStartEntityTracking((Entity)this.field_219461_c, (PlayerEntity)player);
    }

    public void func_219452_a(Consumer<IPacket<?>> p_219452_1_) {
        MobEntity mobentity;
        if (this.field_219461_c.field_70128_L) {
            field_219459_a.warn("Fetching packet for removed entity " + (Object)((Object)this.field_219461_c));
        }
        IPacket<?> ipacket = this.field_219461_c.func_213297_N();
        this.field_219470_l = MathHelper.func_76141_d((float)(this.field_219461_c.func_70079_am() * 256.0f / 360.0f));
        p_219452_1_.accept(ipacket);
        if (!this.field_219461_c.func_184212_Q().func_187228_d()) {
            p_219452_1_.accept((IPacket<?>)new SEntityMetadataPacket(this.field_219461_c.func_145782_y(), this.field_219461_c.func_184212_Q(), true));
        }
        boolean flag = this.field_219463_e;
        if (this.field_219461_c instanceof LivingEntity) {
            EquipmentSlotType[] attributemap = (EquipmentSlotType[])((LivingEntity)this.field_219461_c).func_110140_aT();
            Collection collection = attributemap.func_111160_c();
            if (!collection.isEmpty()) {
                p_219452_1_.accept((IPacket<?>)new SEntityPropertiesPacket(this.field_219461_c.func_145782_y(), collection));
            }
            if (((LivingEntity)this.field_219461_c).func_184613_cA()) {
                flag = true;
            }
        }
        this.field_219471_m = this.field_219461_c.func_213322_ci();
        if (flag && !(ipacket instanceof SSpawnMobPacket)) {
            p_219452_1_.accept((IPacket<?>)new SEntityVelocityPacket(this.field_219461_c.func_145782_y(), this.field_219471_m));
        }
        if (this.field_219461_c instanceof LivingEntity) {
            for (EquipmentSlotType equipmentslottype : EquipmentSlotType.values()) {
                ItemStack itemstack = ((LivingEntity)this.field_219461_c).func_184582_a(equipmentslottype);
                if (itemstack.func_190926_b()) continue;
                p_219452_1_.accept((IPacket<?>)new SEntityEquipmentPacket(this.field_219461_c.func_145782_y(), equipmentslottype, itemstack));
            }
        }
        if (this.field_219461_c instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)this.field_219461_c;
            for (EffectInstance effectinstance : livingentity.func_70651_bq()) {
                p_219452_1_.accept((IPacket<?>)new SPlayEntityEffectPacket(this.field_219461_c.func_145782_y(), effectinstance));
            }
        }
        if (!this.field_219461_c.func_184188_bt().isEmpty()) {
            p_219452_1_.accept((IPacket<?>)new SSetPassengersPacket(this.field_219461_c));
        }
        if (this.field_219461_c.func_184218_aH()) {
            p_219452_1_.accept((IPacket<?>)new SSetPassengersPacket(this.field_219461_c.func_184187_bx()));
        }
        if (this.field_219461_c instanceof MobEntity && (mobentity = (MobEntity)this.field_219461_c).func_110167_bD()) {
            p_219452_1_.accept((IPacket<?>)new SMountEntityPacket((Entity)mobentity, mobentity.func_110166_bE()));
        }
    }

    private void func_219457_c() {
        EntityDataManager entitydatamanager = this.field_219461_c.func_184212_Q();
        if (entitydatamanager.func_187223_a()) {
            this.func_219451_a((IPacket<?>)new SEntityMetadataPacket(this.field_219461_c.func_145782_y(), entitydatamanager, false));
        }
        if (this.field_219461_c instanceof LivingEntity) {
            AttributeMap attributemap = (AttributeMap)((LivingEntity)this.field_219461_c).func_110140_aT();
            Set set = attributemap.func_111161_b();
            if (!set.isEmpty()) {
                this.func_219451_a((IPacket<?>)new SEntityPropertiesPacket(this.field_219461_c.func_145782_y(), (Collection)set));
            }
            set.clear();
        }
    }

    private void func_219458_d() {
        this.field_219465_g = SEntityPacket.func_218743_a((double)this.field_219461_c.func_226277_ct_());
        this.field_219466_h = SEntityPacket.func_218743_a((double)this.field_219461_c.func_226278_cu_());
        this.field_219467_i = SEntityPacket.func_218743_a((double)this.field_219461_c.func_226281_cx_());
    }

    public Vec3d func_219456_b() {
        return SEntityPacket.func_218744_a((long)this.field_219465_g, (long)this.field_219466_h, (long)this.field_219467_i);
    }

    private void func_219451_a(IPacket<?> p_219451_1_) {
        this.field_219464_f.accept(p_219451_1_);
        if (this.field_219461_c instanceof ServerPlayerEntity) {
            ((ServerPlayerEntity)this.field_219461_c).field_71135_a.func_147359_a(p_219451_1_);
        }
    }
}

