/*
 * Decompiled with CFR 0.152.
 */
package com.catastrophe573.dimdungeons.feature;

import com.catastrophe573.dimdungeons.DimDungeons;
import com.catastrophe573.dimdungeons.block.BlockRegistrar;
import com.catastrophe573.dimdungeons.block.TileEntityPortalKeyhole;
import com.catastrophe573.dimdungeons.dimension.DungeonDimensionType;
import com.catastrophe573.dimdungeons.item.ItemPortalKey;
import com.catastrophe573.dimdungeons.structure.DungeonBuilderLogic;
import com.catastrophe573.dimdungeons.structure.DungeonBuilderTestShapes;
import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.state.properties.StructureMode;
import net.minecraft.tileentity.BarrelTileEntity;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.DispenserTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class BasicDungeonFeature
extends Feature<NoFeatureConfig> {
    public static String FEATURE_ID = "feature_basic_dungeon";

    public BasicDungeonFeature(Function<Dynamic<?>, ? extends NoFeatureConfig> function) {
        super(function);
    }

    public boolean place(IWorld world, ChunkGenerator<? extends GenerationSettings> chunkGenerator, Random rand, BlockPos pos, NoFeatureConfig config) {
        DungeonBuilderLogic.DungeonRoom room;
        if (world.func_201675_m().func_186058_p() != DungeonDimensionType.getDimensionType()) {
            DimDungeons.LOGGER.info("DIMDUNGEONS WEIRD ERROR: why is there a dungeon biome outside of the dungeon dimension?");
            return false;
        }
        ChunkPos cpos = new ChunkPos(pos);
        if (BasicDungeonFeature.isDungeonChunk(cpos.field_77276_a, cpos.field_77275_b) && (room = BasicDungeonFeature.getRoomForChunk(cpos, world)) != null) {
            boolean success = BasicDungeonFeature.putRoomHere(cpos, world, room);
            if (!success) {
                DimDungeons.LOGGER.info("DIMDUNGEONS STRUCTURE ERROR: failed to place structure " + room.structure + " at " + cpos.field_77276_a + ", " + cpos.field_77275_b);
            }
            return true;
        }
        return false;
    }

    public static boolean isDungeonChunk(long x, long z) {
        if (x < 0L || z < 0L) {
            return false;
        }
        long plotX = x % 16L;
        long plotZ = z % 16L;
        return plotX > 3L && plotX < 12L && plotZ > 3L && plotZ < 12L;
    }

    public static boolean isEntranceChunk(long x, long z) {
        if (x < 0L || z < 0L) {
            return false;
        }
        long plotX = x % 16L;
        long plotZ = z % 16L;
        return plotX == 8L && plotZ == 11L;
    }

    public static void putTestStructureHere(long x, long z, IWorld world) {
        ChunkPos cpos = new ChunkPos((int)x, (int)z);
        MinecraftServer minecraftserver = world.func_201672_e().func_73046_m();
        TemplateManager templatemanager = minecraftserver.func_71218_a(world.func_201675_m().func_186058_p()).func_184163_y();
        Template template = templatemanager.func_200219_b(new ResourceLocation("dimdungeons:basic_template"));
        PlacementSettings placementsettings = new PlacementSettings().func_186214_a(Mirror.NONE).func_186220_a(Rotation.NONE).func_186222_a(false).func_186218_a(cpos);
        placementsettings.func_186223_a(placementsettings.func_186213_g());
        placementsettings.func_186220_a(Rotation.NONE);
        BlockPos position = new BlockPos(cpos.func_180334_c(), 50, cpos.func_180333_d());
        template.func_189962_a(world, position, placementsettings, 2);
    }

    public static boolean putRoomHere(ChunkPos cpos, IWorld world, DungeonBuilderLogic.DungeonRoom room) {
        MinecraftServer minecraftserver = world.func_201672_e().func_73046_m();
        TemplateManager templatemanager = minecraftserver.func_71218_a(world.func_201675_m().func_186058_p()).func_184163_y();
        Template template = templatemanager.func_200219_b(new ResourceLocation("dimdungeons:" + room.structure));
        PlacementSettings placementsettings = new PlacementSettings().func_186214_a(Mirror.NONE).func_186220_a(Rotation.NONE).func_186222_a(false).func_186218_a(cpos);
        placementsettings.func_186223_a(placementsettings.func_186213_g());
        placementsettings.func_186220_a(room.rotation);
        BlockPos position = new BlockPos(cpos.func_180334_c(), 50, cpos.func_180333_d());
        if (template == null) {
            DimDungeons.LOGGER.info("DIMDUNGEONS FATAL ERROR: Structure does not exist (" + room.structure + ")");
            return false;
        }
        if (room.rotation == Rotation.COUNTERCLOCKWISE_90) {
            placementsettings.func_186220_a(Rotation.COUNTERCLOCKWISE_90);
            position = position.func_177982_a(0, 0, template.func_186259_a().func_177952_p() - 1);
        } else if (room.rotation == Rotation.CLOCKWISE_90) {
            placementsettings.func_186220_a(Rotation.CLOCKWISE_90);
            position = position.func_177982_a(template.func_186259_a().func_177958_n() - 1, 0, 0);
        } else if (room.rotation == Rotation.CLOCKWISE_180) {
            placementsettings.func_186220_a(Rotation.CLOCKWISE_180);
            position = position.func_177982_a(template.func_186259_a().func_177958_n() - 1, 0, template.func_186259_a().func_177952_p() - 1);
        } else {
            placementsettings.func_186220_a(Rotation.NONE);
        }
        boolean success = template.func_189962_a(world, position, placementsettings, 2);
        for (Template.BlockInfo template$blockinfo : template.func_215381_a(position, placementsettings, Blocks.field_185779_df)) {
            StructureMode structuremode;
            if (template$blockinfo.field_186244_c == null || (structuremode = StructureMode.valueOf((String)template$blockinfo.field_186244_c.func_74779_i("mode"))) != StructureMode.DATA) continue;
            BasicDungeonFeature.handleDataBlock(template$blockinfo.field_186244_c.func_74779_i("metadata"), template$blockinfo.field_186242_a, world, world.func_201674_k(), placementsettings.func_186213_g());
        }
        return success;
    }

    public static DungeonBuilderLogic.DungeonRoom getRoomForChunk(ChunkPos cpos, IWorld world) {
        int distToEntranceZ;
        int distToEntranceX;
        int entranceX = cpos.field_77276_a;
        int entranceZ = cpos.field_77275_b;
        if (!BasicDungeonFeature.isEntranceChunk(entranceX += (distToEntranceX = 8 - entranceX % 16), entranceZ += (distToEntranceZ = 11 - entranceZ % 16))) {
            DimDungeons.LOGGER.info("DIMDUNGEONS MAJOR ERROR: attempting to generate a dungeon at a chunk which isn't an entrance chunk! (" + entranceX + ", " + entranceZ + ")");
            return null;
        }
        DungeonBuilderLogic dbl = new DungeonBuilderLogic(world.func_72905_C(), entranceX, entranceZ);
        if (world.func_72912_H().func_76065_j().equalsIgnoreCase("DimDungeonsDebugOne")) {
            DungeonBuilderTestShapes.MakeTestDungeonEnds(dbl);
        } else if (world.func_72912_H().func_76065_j().equalsIgnoreCase("DimDungeonsDebugTwo")) {
            DungeonBuilderTestShapes.MakeTestDungeonTwos(dbl);
        } else if (world.func_72912_H().func_76065_j().equalsIgnoreCase("DimDungeonsDebugThree")) {
            DungeonBuilderTestShapes.MakeTestDungeonThreesAndFours(dbl);
        } else {
            dbl.calculateDungeonShape(25);
        }
        int i = cpos.field_77276_a % 16 - 4;
        int j = cpos.field_77275_b % 16 - 4;
        DungeonBuilderLogic.DungeonRoom nextRoom = dbl.finalLayout[i][j];
        if (!nextRoom.hasRoom()) {
            return null;
        }
        return nextRoom;
    }

    public void printMap(DungeonBuilderLogic dbl) {
        for (int j = 0; j < 8; ++j) {
            String dungeonRowShape = "";
            for (int i = 0; i < 8; ++i) {
                dungeonRowShape = dungeonRowShape + (dbl.finalLayout[i][j].hasRoom() ? "*" : ".");
            }
            System.out.println(dungeonRowShape);
        }
    }

    public void UNUSEDgenerateDungeonAroundChunk(long x, long z, IWorld world, Random rand) {
        MinecraftServer minecraftserver = world.func_201672_e().func_73046_m();
        TemplateManager templatemanager = minecraftserver.func_71218_a(world.func_201675_m().func_186058_p()).func_184163_y();
        DungeonBuilderLogic dbl = new DungeonBuilderLogic(world.func_72905_C(), x, z);
        dbl.calculateDungeonShape(10);
        System.out.println("Making a dungeon at " + x + ", " + z + "!");
        for (int j = 0; j < 8; ++j) {
            String dungeonRowShape = "";
            for (int i = 0; i < 8; ++i) {
                dungeonRowShape = dungeonRowShape + (dbl.finalLayout[i][j].hasRoom() ? "*" : ".");
            }
            System.out.println(dungeonRowShape);
        }
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                DungeonBuilderLogic.DungeonRoom nextRoom = dbl.finalLayout[i][j];
                if (!nextRoom.hasRoom()) {
                    System.out.println("NO ROOM AT " + i + ", " + j + "!");
                    continue;
                }
                ChunkPos chunkpos = new ChunkPos((int)x + i, (int)z + j);
                BlockPos position = new BlockPos(chunkpos.func_180334_c(), 50, chunkpos.func_180333_d());
                if (!world.func_217354_b(chunkpos.field_77276_a, chunkpos.field_77275_b)) {
                    DimDungeons.LOGGER.info("CHUNK DOES NOT EXIST! DO NOT BUILD HERE! " + chunkpos.field_77276_a + ", " + chunkpos.field_77275_b);
                    continue;
                }
                Template template = templatemanager.func_200219_b(new ResourceLocation("dimdungeons:" + nextRoom.structure));
                PlacementSettings placementsettings = new PlacementSettings().func_186214_a(Mirror.NONE).func_186220_a(Rotation.NONE).func_186222_a(false).func_186218_a(chunkpos);
                placementsettings.func_186223_a(placementsettings.func_186213_g());
                boolean success = false;
                if (nextRoom.rotation == Rotation.COUNTERCLOCKWISE_90) {
                    placementsettings.func_186220_a(Rotation.COUNTERCLOCKWISE_90);
                    position = position.func_177982_a(0, 0, template.func_186259_a().func_177952_p() - 1);
                    System.out.println("template placement CCW: " + position.toString() + " " + nextRoom.structure);
                    success = template.func_189962_a(world, position, placementsettings, 2);
                } else if (nextRoom.rotation == Rotation.CLOCKWISE_90) {
                    placementsettings.func_186220_a(Rotation.CLOCKWISE_90);
                    position = position.func_177982_a(template.func_186259_a().func_177958_n() - 1, 0, 0);
                    System.out.println("template placement CW: " + position.toString() + " " + nextRoom.structure);
                    success = template.func_189962_a(world, position, placementsettings, 2);
                } else if (nextRoom.rotation == Rotation.CLOCKWISE_180) {
                    placementsettings.func_186220_a(Rotation.CLOCKWISE_180);
                    position = position.func_177982_a(template.func_186259_a().func_177958_n() - 1, 0, template.func_186259_a().func_177952_p() - 1);
                    System.out.println("template placement 180: " + position.toString() + " " + nextRoom.structure);
                    success = template.func_189962_a(world, position, placementsettings, 2);
                } else {
                    placementsettings.func_186220_a(Rotation.NONE);
                    System.out.println("template placement NONE: " + position.toString() + " " + nextRoom.structure);
                    success = template.func_189962_a(world, position, placementsettings, 2);
                }
                if (!success) {
                    DimDungeons.LOGGER.info("FAILED TO PLACE THAT LAST STRUCTURE? Moving on. ");
                    continue;
                }
                for (Template.BlockInfo template$blockinfo : template.func_215381_a(position, placementsettings, Blocks.field_185779_df)) {
                    StructureMode structuremode;
                    if (template$blockinfo.field_186244_c != null && (structuremode = StructureMode.valueOf((String)template$blockinfo.field_186244_c.func_74779_i("mode"))) != StructureMode.DATA) continue;
                }
            }
        }
    }

    protected static void handleDataBlock(String name, BlockPos pos, IWorld world, Random rand, MutableBoundingBox bb) {
        if ("LockIt".equals(name)) {
            BasicDungeonFeature.LockDispensersAround(world, pos);
            world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
        } else if ("LockItStoneBrick".equals(name)) {
            BasicDungeonFeature.LockDispensersAround(world, pos);
            world.func_180501_a(pos, Blocks.field_196696_di.func_176223_P(), 2);
        } else if ("ReturnPortal".equals(name)) {
            BasicDungeonFeature.LockDispensersAround(world, pos);
            world.func_180501_a(pos, BlockRegistrar.block_gold_portal.func_176223_P(), 2);
        } else if ("FortuneTeller".equals(name)) {
            world.func_180501_a(pos, Blocks.field_196696_di.func_176223_P(), 2);
            BasicDungeonFeature.faceContainerTowardsAir(world, pos.func_177977_b());
            BasicDungeonFeature.LockDispensersAround(world, pos.func_177977_b());
            TileEntity te = world.func_175625_s(pos.func_177977_b());
            if (te instanceof DispenserTileEntity) {
                ((DispenserTileEntity)te).func_174888_l();
                ItemStack message = BasicDungeonFeature.generateLuckyMessage(rand);
                ((DispenserTileEntity)te).func_146019_a(message);
            } else {
                DimDungeons.LOGGER.info("DIMDUNGEONS TILE ENTITY ERROR: unable to place a fortune teller block.");
            }
        } else if ("ChestLoot1".equals(name)) {
            int lucky = rand.nextInt(100);
            if (lucky < 80) {
                BasicDungeonFeature.fillChestBelow(pos, new ResourceLocation("dimdungeons:chests/chestloot_1"), world, rand);
            } else {
                BasicDungeonFeature.fillChestBelow(pos, new ResourceLocation("dimdungeons:chests/chestloot_2"), world, rand);
            }
        } else if ("ChestLoot2".equals(name)) {
            BasicDungeonFeature.fillChestBelow(pos, new ResourceLocation("dimdungeons:chests/chestloot_2"), world, rand);
        } else if ("ChestLootLucky".equals(name)) {
            int lucky = rand.nextInt(100);
            if (lucky < 30) {
                BasicDungeonFeature.fillChestBelow(pos, new ResourceLocation("dimdungeons:chests/chestloot_lucky"), world, rand);
            } else {
                world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
                world.func_180501_a(pos.func_177977_b(), Blocks.field_150350_a.func_176223_P(), 2);
            }
        } else if ("SetTrappedLoot".equals(name)) {
            world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
            ChestTileEntity te = (ChestTileEntity)world.func_175625_s(pos.func_177977_b());
            if (te != null) {
                te.func_174888_l();
                te.func_189404_a(new ResourceLocation("dimdungeons:chests/chestloot_1"), rand.nextLong());
            }
        } else if ("BarrelLoot1".equals(name)) {
            int lucky = rand.nextInt(100);
            if (lucky < 80) {
                BasicDungeonFeature.fillBarrelBelow(pos, new ResourceLocation("dimdungeons:chests/chestloot_1"), world, rand);
            } else {
                BasicDungeonFeature.fillBarrelBelow(pos, new ResourceLocation("dimdungeons:chests/chestloot_2"), world, rand);
            }
        } else if ("PlaceL2Key".equals(name)) {
            ItemStack key;
            world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
            TileEntityPortalKeyhole te = (TileEntityPortalKeyhole)world.func_175625_s(pos.func_177977_b());
            if (te != null && (key = te.getObjectInserted()).func_77973_b() instanceof ItemPortalKey) {
                ((ItemPortalKey)key.func_77973_b()).activateKeyLevel2(key);
                te.setContents(key);
            }
        } else if ("SummonWitch".equals(name)) {
            world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
            BasicDungeonFeature.spawnEnemyHere(pos, "witch", world);
        } else if ("SummonWaterEnemy".equals(name)) {
            world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
            int chance = rand.nextInt(100);
            if (chance < 80) {
                BasicDungeonFeature.spawnEnemyHere(pos, "guardian", world);
            } else {
                BasicDungeonFeature.spawnEnemyHere(pos, "drowned", world);
            }
        } else if ("SummonEnderman".equals(name)) {
            world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
            BasicDungeonFeature.spawnEnemyHere(pos, "enderman", world);
        } else if ("SummonEnemy1".equals(name)) {
            world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
            int chance = rand.nextInt(100);
            if (chance < 16) {
                BasicDungeonFeature.spawnEnemyHere(pos, "zombie", world);
            } else if (chance < 32) {
                BasicDungeonFeature.spawnEnemyHere(pos, "husk", world);
            } else if (chance < 48) {
                BasicDungeonFeature.spawnEnemyHere(pos, "drowned", world);
            } else if (chance < 64) {
                BasicDungeonFeature.spawnEnemyHere(pos, "spider", world);
            }
        } else if ("SummonEnemy2".equals(name)) {
            world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
            int chance = rand.nextInt(100);
            if (chance < 20) {
                BasicDungeonFeature.spawnEnemyHere(pos, "wither_skeleton", world);
            } else if (chance < 40) {
                BasicDungeonFeature.spawnEnemyHere(pos, "stray", world);
            } else if (chance < 60) {
                BasicDungeonFeature.spawnEnemyHere(pos, "skeleton", world);
            } else if (chance < 80) {
                BasicDungeonFeature.spawnEnemyHere(pos, "pillager", world);
            }
        } else {
            DimDungeons.LOGGER.info("UNHANDLED DATA BLOCK WITH name = " + name);
            world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
        }
    }

    private static void spawnEnemyHere(BlockPos pos, String casualName, IWorld world) {
        MobEntity mob = null;
        if ("witch".contentEquals(casualName)) {
            mob = (MobEntity)EntityType.field_200759_ay.func_200721_a(world.func_201672_e());
            mob.func_70107_b((double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p());
        } else if ("enderman".contentEquals(casualName)) {
            mob = (MobEntity)EntityType.field_200803_q.func_200721_a(world.func_201672_e());
            mob.func_70107_b((double)pos.func_177958_n(), (double)(pos.func_177956_o() + 2), (double)pos.func_177952_p());
        } else if ("guardian".contentEquals(casualName)) {
            mob = (MobEntity)EntityType.field_200761_A.func_200721_a(world.func_201672_e());
            mob.func_70107_b((double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p());
        } else if ("zombie".contentEquals(casualName)) {
            mob = (MobEntity)EntityType.field_200725_aD.func_200721_a(world.func_201672_e());
            mob.func_70107_b((double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p());
        } else if ("husk".contentEquals(casualName)) {
            mob = (MobEntity)EntityType.field_200763_C.func_200721_a(world.func_201672_e());
            mob.func_70107_b((double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p());
        } else if ("drowned".contentEquals(casualName)) {
            mob = (MobEntity)EntityType.field_204724_o.func_200721_a(world.func_201672_e());
            mob.func_70107_b((double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p());
        } else if ("skeleton".contentEquals(casualName)) {
            mob = (MobEntity)EntityType.field_200741_ag.func_200721_a(world.func_201672_e());
            mob.func_70107_b((double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p());
        } else if ("wither_skeleton".contentEquals(casualName)) {
            mob = (MobEntity)EntityType.field_200722_aA.func_200721_a(world.func_201672_e());
            mob.func_70107_b((double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p());
        } else if ("stray".contentEquals(casualName)) {
            mob = (MobEntity)EntityType.field_200750_ap.func_200721_a(world.func_201672_e());
            mob.func_70107_b((double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p());
        } else if ("spider".contentEquals(casualName)) {
            mob = (MobEntity)EntityType.field_200748_an.func_200721_a(world.func_201672_e());
            mob.func_70107_b((double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p());
        } else if ("pillager".contentEquals(casualName)) {
            mob = (MobEntity)EntityType.field_220350_aJ.func_200721_a(world.func_201672_e());
            mob.func_70107_b((double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p());
        } else {
            System.out.println("DungeonChunkGenerator: Attempting to spawn unrecognized enemy: " + casualName);
            return;
        }
        mob.func_98053_h(false);
        mob.func_200203_b((ITextComponent)new TranslationTextComponent("enemy.dimdungeons." + casualName, new Object[0]));
        mob.func_213390_a(pos, 8);
        mob.func_174828_a(pos, 0.0f, 0.0f);
        mob.func_110163_bv();
        mob.func_213386_a(world, world.func_175649_E(pos), SpawnReason.STRUCTURE, (ILivingEntityData)null, (CompoundNBT)null);
        world.func_217376_c((Entity)mob);
    }

    private static void fillChestBelow(BlockPos pos, ResourceLocation lootTable, IWorld world, Random rand) {
        world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
        BasicDungeonFeature.faceContainerTowardsAir(world, pos.func_177977_b());
        TileEntity te = world.func_175625_s(pos.func_177977_b());
        if (te instanceof ChestTileEntity) {
            ((ChestTileEntity)te).func_174888_l();
            ((ChestTileEntity)te).func_189404_a(lootTable, rand.nextLong());
        } else {
            DimDungeons.LOGGER.info("DIMDUNGEONS: FAILED TO PLACE CHEST IN DUNGEON. pos = " + pos.func_177958_n() + ", " + pos.func_177952_p());
        }
    }

    private static void fillBarrelBelow(BlockPos pos, ResourceLocation lootTable, IWorld world, Random rand) {
        world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
        TileEntity te = world.func_175625_s(pos.func_177977_b());
        if (te instanceof BarrelTileEntity) {
            ((BarrelTileEntity)te).func_174888_l();
            ((BarrelTileEntity)te).func_189404_a(lootTable, rand.nextLong());
        } else {
            DimDungeons.LOGGER.info("DIMDUNGEONS: FAILED TO PLACE BARREL IN DUNGEON. pos = " + pos.func_177958_n() + ", " + pos.func_177952_p());
        }
    }

    private static ItemStack generateLuckyMessage(Random rand) {
        ItemStack stack = new ItemStack((IItemProvider)Items.field_151164_bB);
        stack.func_77982_d(new CompoundNBT());
        int bookType = rand.nextInt(3);
        int messageVariation = rand.nextInt(8) + 1;
        String body = "";
        String title = "";
        if (bookType == 0) {
            title = new TranslationTextComponent("book.dimdungeons.title_1", new Object[0]).getString();
            body = new TranslationTextComponent("book.dimdungeons.fun_message_" + messageVariation, new Object[0]).getString();
        } else if (bookType == 1) {
            title = new TranslationTextComponent("book.dimdungeons.title_2", new Object[0]).getString();
            body = new TranslationTextComponent("book.dimdungeons.helpful_message_" + messageVariation, new Object[0]).getString();
        } else {
            title = new TranslationTextComponent("book.dimdungeons.title_3", new Object[0]).getString();
            body = new TranslationTextComponent("book.dimdungeons.dangerous_message_" + messageVariation, new Object[0]).getString();
        }
        ListNBT pages = new ListNBT();
        TranslationTextComponent text = new TranslationTextComponent(body, new Object[0]);
        String json = ITextComponent.Serializer.func_150696_a((ITextComponent)text);
        pages.add(0, (INBT)StringNBT.func_229705_a_((String)json));
        stack.func_77978_p().func_74757_a("resolved", false);
        stack.func_77978_p().func_74768_a("generation", 0);
        stack.func_77978_p().func_218657_a("pages", (INBT)pages);
        stack.func_77978_p().func_74778_a("title", title);
        stack.func_77978_p().func_74778_a("author", new TranslationTextComponent("book.dimdungeons.author", new Object[0]).getString());
        return stack;
    }

    private static void LockDispensersAround(IWorld world, BlockPos pos) {
    }

    private static void faceContainerTowardsAir(IWorld world, BlockPos pos) {
        BlockState bs = world.func_180495_p(pos);
        if (bs.func_177230_c() == Blocks.field_150367_z || bs.func_177230_c() == Blocks.field_150486_ae) {
            if (world.func_180495_p(pos.func_177978_c()).func_177230_c() == Blocks.field_150350_a) {
                // empty if block
            }
            if (world.func_180495_p(pos.func_177968_d()).func_177230_c() == Blocks.field_150350_a) {
                // empty if block
            }
            if (world.func_180495_p(pos.func_177976_e()).func_177230_c() == Blocks.field_150350_a) {
                // empty if block
            }
            if (world.func_180495_p(pos.func_177974_f()).func_177230_c() == Blocks.field_150350_a) {
                // empty if block
            }
            world.func_180501_a(pos, bs, 2);
        }
    }
}

