/*
 * Decompiled with CFR 0.152.
 */
package com.catastrophe573.dimdungeons.feature;

import com.catastrophe573.dimdungeons.DimDungeons;
import com.catastrophe573.dimdungeons.block.BlockRegistrar;
import com.catastrophe573.dimdungeons.block.TileEntityPortalKeyhole;
import com.catastrophe573.dimdungeons.dimension.DungeonDimensionType;
import com.catastrophe573.dimdungeons.item.ItemPortalKey;
import com.catastrophe573.dimdungeons.structure.DungeonBuilderLogic;
import com.catastrophe573.dimdungeons.structure.DungeonBuilderTestShapes;
import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.server.MinecraftServer;
import net.minecraft.state.properties.StructureMode;
import net.minecraft.tileentity.BarrelTileEntity;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.DispenserTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class AdvancedDungeonFeature
extends Feature<NoFeatureConfig> {
    public static String FEATURE_ID = "feature_advanced_dungeon";

    public AdvancedDungeonFeature(Function<Dynamic<?>, ? extends NoFeatureConfig> function) {
        super(function);
    }

    public boolean place(IWorld world, ChunkGenerator<? extends GenerationSettings> chunkGenerator, Random rand, BlockPos pos, NoFeatureConfig config) {
        DungeonBuilderLogic.DungeonRoom room;
        if (world.func_201675_m().func_186058_p() != DungeonDimensionType.getDimensionType()) {
            DimDungeons.LOGGER.info("DIMDUNGEONS WEIRD ERROR: why is there a dungeon biome outside of the dungeon dimension?");
            return false;
        }
        ChunkPos cpos = new ChunkPos(pos);
        if (AdvancedDungeonFeature.isDungeonChunk(cpos.field_77276_a, cpos.field_77275_b) && (room = AdvancedDungeonFeature.getRoomForChunk(cpos, world)) != null) {
            boolean success = AdvancedDungeonFeature.putRoomHere(cpos, world, room);
            if (!success) {
                DimDungeons.LOGGER.info("DIMDUNGEONS STRUCTURE ERROR: failed to place structure " + room.structure + " at " + cpos.field_77276_a + ", " + cpos.field_77275_b);
            }
            return true;
        }
        return false;
    }

    public static boolean isDungeonChunk(long x, long z) {
        if (x < 0L || z > 0L) {
            return false;
        }
        long plotX = x % 16L;
        long plotZ = z % 16L;
        return plotX > 3L && plotX < 12L && plotZ < -4L && plotZ > -13L;
    }

    public static boolean isEntranceChunk(long x, long z) {
        if (x < 0L || z > 0L) {
            return false;
        }
        long plotX = x % 16L;
        long plotZ = z % 16L;
        return plotX == 8L && plotZ == -5L;
    }

    public static boolean putRoomHere(ChunkPos cpos, IWorld world, DungeonBuilderLogic.DungeonRoom room) {
        MinecraftServer minecraftserver = world.func_201672_e().func_73046_m();
        TemplateManager templatemanager = minecraftserver.func_71218_a(world.func_201675_m().func_186058_p()).func_184163_y();
        Template template = templatemanager.func_200219_b(new ResourceLocation("dimdungeons:" + room.structure));
        PlacementSettings placementsettings = new PlacementSettings().func_186214_a(Mirror.NONE).func_186220_a(Rotation.NONE).func_186222_a(false).func_186218_a(cpos);
        placementsettings.func_186223_a(placementsettings.func_186213_g());
        placementsettings.func_186220_a(room.rotation);
        BlockPos position = new BlockPos(cpos.func_180334_c(), 50, cpos.func_180333_d());
        if (template == null) {
            DimDungeons.LOGGER.info("DIMDUNGEONS FATAL ERROR: Structure does not exist (" + room.structure + ")");
            return false;
        }
        if (room.rotation == Rotation.COUNTERCLOCKWISE_90) {
            placementsettings.func_186220_a(Rotation.COUNTERCLOCKWISE_90);
            position = position.func_177982_a(0, 0, template.func_186259_a().func_177952_p() - 1);
        } else if (room.rotation == Rotation.CLOCKWISE_90) {
            placementsettings.func_186220_a(Rotation.CLOCKWISE_90);
            position = position.func_177982_a(template.func_186259_a().func_177958_n() - 1, 0, 0);
        } else if (room.rotation == Rotation.CLOCKWISE_180) {
            placementsettings.func_186220_a(Rotation.CLOCKWISE_180);
            position = position.func_177982_a(template.func_186259_a().func_177958_n() - 1, 0, template.func_186259_a().func_177952_p() - 1);
        } else {
            placementsettings.func_186220_a(Rotation.NONE);
        }
        boolean success = template.func_189962_a(world, position, placementsettings, 2);
        for (Template.BlockInfo template$blockinfo : template.func_215381_a(position, placementsettings, Blocks.field_185779_df)) {
            StructureMode structuremode;
            if (template$blockinfo.field_186244_c == null || (structuremode = StructureMode.valueOf((String)template$blockinfo.field_186244_c.func_74779_i("mode"))) != StructureMode.DATA) continue;
            AdvancedDungeonFeature.handleDataBlock(template$blockinfo.field_186244_c.func_74779_i("metadata"), template$blockinfo.field_186242_a, world, world.func_201674_k(), placementsettings.func_186213_g());
        }
        for (Template.BlockInfo info : template.func_215381_a(position, placementsettings, Blocks.field_196751_fV)) {
            world.func_180501_a(info.field_186242_a, Blocks.field_196749_fU.func_176223_P(), 3);
        }
        return success;
    }

    public static DungeonBuilderLogic.DungeonRoom getRoomForChunk(ChunkPos cpos, IWorld world) {
        int distToEntranceZ;
        int distToEntranceX;
        int entranceX = cpos.field_77276_a;
        int entranceZ = cpos.field_77275_b;
        if (!AdvancedDungeonFeature.isEntranceChunk(entranceX += (distToEntranceX = 8 - entranceX % 16), entranceZ -= (distToEntranceZ = 5 + entranceZ % 16))) {
            DimDungeons.LOGGER.info("DIMDUNGEONS MAJOR ERROR: attempting to generate a dungeon at a chunk which isn't an entrance chunk! (" + entranceX + ", " + entranceZ + ")");
            return null;
        }
        DungeonBuilderLogic dbl = new DungeonBuilderLogic(world.func_72905_C(), entranceX, entranceZ);
        if (world.func_72912_H().func_76065_j().equalsIgnoreCase("DimDungeonsDebugOne")) {
            DungeonBuilderTestShapes.MakeTestDungeonEnds(dbl);
        } else if (world.func_72912_H().func_76065_j().equalsIgnoreCase("DimDungeonsDebugTwo")) {
            DungeonBuilderTestShapes.MakeTestDungeonTwos(dbl);
        } else if (world.func_72912_H().func_76065_j().equalsIgnoreCase("DimDungeonsDebugThree")) {
            DungeonBuilderTestShapes.MakeTestDungeonThreesAndFours(dbl);
        } else {
            dbl.calculateDungeonShape(52);
        }
        int i = cpos.field_77276_a % 16 - 4;
        int j = cpos.field_77275_b % 16 + 12;
        DungeonBuilderLogic.DungeonRoom nextRoom = dbl.finalLayout[i][j];
        if (!nextRoom.hasRoom()) {
            return null;
        }
        return nextRoom;
    }

    public void printMap(DungeonBuilderLogic dbl) {
        for (int j = 0; j < 8; ++j) {
            String dungeonRowShape = "";
            for (int i = 0; i < 8; ++i) {
                dungeonRowShape = dungeonRowShape + (dbl.finalLayout[i][j].hasRoom() ? "*" : ".");
            }
            System.out.println(dungeonRowShape);
        }
    }

    protected static void handleDataBlock(String name, BlockPos pos, IWorld world, Random rand, MutableBoundingBox bb) {
        if ("LockIt".equals(name)) {
            AdvancedDungeonFeature.LockDispensersAround(world, pos);
            world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
        } else if ("LockItStoneBrick".equals(name)) {
            AdvancedDungeonFeature.LockDispensersAround(world, pos);
            world.func_180501_a(pos, Blocks.field_196696_di.func_176223_P(), 2);
        } else if ("ReturnPortal".equals(name)) {
            AdvancedDungeonFeature.LockDispensersAround(world, pos);
            world.func_180501_a(pos, BlockRegistrar.block_gold_portal.func_176223_P(), 2);
        } else if ("FortuneTeller".equals(name)) {
            world.func_180501_a(pos, Blocks.field_196696_di.func_176223_P(), 2);
            AdvancedDungeonFeature.faceContainerTowardsAir(world, pos.func_177977_b());
            AdvancedDungeonFeature.LockDispensersAround(world, pos.func_177977_b());
            TileEntity te = world.func_175625_s(pos.func_177977_b());
            if (te instanceof DispenserTileEntity) {
                ((DispenserTileEntity)te).func_174888_l();
                ItemStack message = AdvancedDungeonFeature.generateLuckyMessage(rand);
                ((DispenserTileEntity)te).func_146019_a(message);
            } else {
                DimDungeons.LOGGER.info("DIMDUNGEONS TILE ENTITY ERROR: unable to place a fortune teller block.");
            }
        } else if ("ChestLoot1".equals(name)) {
            int lucky = rand.nextInt(100);
            if (lucky < 80) {
                AdvancedDungeonFeature.fillChestBelow(pos, new ResourceLocation("dimdungeons:chests/chestloot_3"), world, rand);
            } else {
                AdvancedDungeonFeature.fillChestBelow(pos, new ResourceLocation("dimdungeons:chests/chestloot_4"), world, rand);
            }
        } else if ("ChestLoot2".equals(name)) {
            AdvancedDungeonFeature.fillChestBelow(pos, new ResourceLocation("dimdungeons:chests/chestloot_4"), world, rand);
        } else if ("ChestLootLucky".equals(name)) {
            int lucky = rand.nextInt(100);
            if (lucky < 30) {
                AdvancedDungeonFeature.fillChestBelow(pos, new ResourceLocation("dimdungeons:chests/chestloot_crazy"), world, rand);
            } else {
                world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
                world.func_180501_a(pos.func_177977_b(), Blocks.field_150350_a.func_176223_P(), 2);
            }
        } else if ("SetTrappedLoot".equals(name)) {
            world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
            ChestTileEntity te = (ChestTileEntity)world.func_175625_s(pos.func_177977_b());
            if (te != null) {
                te.func_174888_l();
                te.func_189404_a(new ResourceLocation("dimdungeons:chests/chestloot_3"), rand.nextLong());
            }
        } else if ("BarrelLoot1".equals(name)) {
            int lucky = rand.nextInt(100);
            if (lucky < 80) {
                AdvancedDungeonFeature.fillBarrelBelow(pos, new ResourceLocation("dimdungeons:chests/chestloot_3"), world, rand);
            } else {
                AdvancedDungeonFeature.fillBarrelBelow(pos, new ResourceLocation("dimdungeons:chests/chestloot_4"), world, rand);
            }
        } else if ("PlaceL2Key".equals(name)) {
            ItemStack key;
            world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
            TileEntityPortalKeyhole te = (TileEntityPortalKeyhole)world.func_175625_s(pos.func_177977_b());
            if (te != null && (key = te.getObjectInserted()).func_77973_b() instanceof ItemPortalKey) {
                ((ItemPortalKey)key.func_77973_b()).activateKeyLevel2(key);
                te.setContents(key);
            }
        } else if ("SummonWitch".equals(name)) {
            world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
            AdvancedDungeonFeature.spawnEnemyHere(pos, "witch", world);
        } else if ("SummonWaterEnemy".equals(name)) {
            world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
            AdvancedDungeonFeature.spawnEnemyHere(pos, "guardian", world);
        } else if ("SummonEnderman".equals(name)) {
            world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
            AdvancedDungeonFeature.spawnEnemyHere(pos, "enderman", world);
        } else if ("SummonEnemy1".equals(name)) {
            world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
            int chance = rand.nextInt(100);
            if (chance < 16) {
                AdvancedDungeonFeature.spawnEnemyHere(pos, "zombie", world);
            } else if (chance < 32) {
                AdvancedDungeonFeature.spawnEnemyHere(pos, "husk", world);
            } else if (chance < 48) {
                AdvancedDungeonFeature.spawnEnemyHere(pos, "drowned", world);
            } else if (chance < 74) {
                AdvancedDungeonFeature.spawnEnemyHere(pos, "blaze", world);
            } else {
                AdvancedDungeonFeature.spawnEnemyHere(pos, "spider", world);
            }
        } else if ("SummonEnemy2".equals(name)) {
            world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
            int chance = rand.nextInt(100);
            if (chance < 20) {
                AdvancedDungeonFeature.spawnEnemyHere(pos, "wither_skeleton", world);
            } else if (chance < 40) {
                AdvancedDungeonFeature.spawnEnemyHere(pos, "stray", world);
            } else if (chance < 60) {
                AdvancedDungeonFeature.spawnEnemyHere(pos, "skeleton", world);
            } else if (chance < 80) {
                AdvancedDungeonFeature.spawnEnemyHere(pos, "pillager", world);
            }
        } else {
            DimDungeons.LOGGER.info("UNHANDLED DATA BLOCK WITH name = " + name);
            world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
        }
    }

    private static void spawnEnemyHere(BlockPos pos, String casualName, IWorld world) {
        MobEntity mob = null;
        if ("witch".contentEquals(casualName)) {
            mob = (MobEntity)EntityType.field_200759_ay.func_200721_a(world.func_201672_e());
            mob.func_70107_b((double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p());
            mob.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.35f);
            mob.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(40.0);
            mob.func_70606_j(40.0f);
        } else if ("enderman".contentEquals(casualName)) {
            mob = (MobEntity)EntityType.field_200803_q.func_200721_a(world.func_201672_e());
            mob.func_70107_b((double)pos.func_177958_n(), (double)(pos.func_177956_o() + 2), (double)pos.func_177952_p());
            mob.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.4f);
            mob.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(50.0);
            mob.func_70606_j(50.0f);
        } else if ("guardian".contentEquals(casualName)) {
            mob = (MobEntity)EntityType.field_200761_A.func_200721_a(world.func_201672_e());
            mob.func_70107_b((double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p());
            mob.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.4f);
            mob.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(40.0);
            mob.func_70606_j(40.0f);
        } else if ("zombie".contentEquals(casualName)) {
            mob = (MobEntity)EntityType.field_200725_aD.func_200721_a(world.func_201672_e());
            mob.func_70107_b((double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p());
            mob.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.35f);
            mob.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0);
            mob.func_70606_j(32.0f);
        } else if ("husk".contentEquals(casualName)) {
            mob = (MobEntity)EntityType.field_200763_C.func_200721_a(world.func_201672_e());
            mob.func_70107_b((double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p());
            mob.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.35f);
            mob.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0);
            mob.func_70606_j(32.0f);
        } else if ("drowned".contentEquals(casualName)) {
            mob = (MobEntity)EntityType.field_204724_o.func_200721_a(world.func_201672_e());
            mob.func_70107_b((double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p());
            mob.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.35f);
            mob.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0);
            mob.func_70606_j(32.0f);
        } else if ("skeleton".contentEquals(casualName)) {
            mob = (MobEntity)EntityType.field_200741_ag.func_200721_a(world.func_201672_e());
            mob.func_70107_b((double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p());
            mob.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.4f);
            mob.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0);
            mob.func_70606_j(40.0f);
        } else if ("wither_skeleton".contentEquals(casualName)) {
            mob = (MobEntity)EntityType.field_200722_aA.func_200721_a(world.func_201672_e());
            mob.func_70107_b((double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p());
            mob.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.35f);
            mob.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0);
            mob.func_70606_j(30.0f);
        } else if ("stray".contentEquals(casualName)) {
            mob = (MobEntity)EntityType.field_200750_ap.func_200721_a(world.func_201672_e());
            mob.func_70107_b((double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p());
            mob.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.45f);
            mob.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0);
            mob.func_70606_j(40.0f);
        } else if ("spider".contentEquals(casualName)) {
            mob = (MobEntity)EntityType.field_200748_an.func_200721_a(world.func_201672_e());
            mob.func_70107_b((double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p());
            mob.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.4f);
            mob.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(36.0);
            mob.func_70606_j(36.0f);
        } else if ("pillager".contentEquals(casualName)) {
            mob = (MobEntity)EntityType.field_220350_aJ.func_200721_a(world.func_201672_e());
            mob.func_70107_b((double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p());
            mob.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.35f);
            mob.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(36.0);
            mob.func_70606_j(36.0f);
        } else if ("blaze".contentEquals(casualName)) {
            mob = (MobEntity)EntityType.field_200792_f.func_200721_a(world.func_201672_e());
            mob.func_70107_b((double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p());
            mob.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.35f);
            mob.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0);
            mob.func_70606_j(30.0f);
        } else {
            System.out.println("DungeonChunkGenerator: Attempting to spawn unrecognized enemy: " + casualName);
            return;
        }
        mob.func_98053_h(false);
        mob.func_200203_b((ITextComponent)new TranslationTextComponent("enemy.dimdungeons." + casualName + "2", new Object[0]));
        mob.func_213390_a(pos, 8);
        mob.func_174828_a(pos, 0.0f, 0.0f);
        mob.func_110163_bv();
        mob.func_195064_c(new EffectInstance(Effects.field_76426_n, 9999999));
        mob.func_195064_c(new EffectInstance(Effects.field_76430_j, 9999999, 3));
        mob.func_213386_a(world, world.func_175649_E(pos), SpawnReason.STRUCTURE, (ILivingEntityData)null, (CompoundNBT)null);
        world.func_217376_c((Entity)mob);
    }

    private static void fillChestBelow(BlockPos pos, ResourceLocation lootTable, IWorld world, Random rand) {
        world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
        AdvancedDungeonFeature.faceContainerTowardsAir(world, pos.func_177977_b());
        TileEntity te = world.func_175625_s(pos.func_177977_b());
        if (te instanceof ChestTileEntity) {
            ((ChestTileEntity)te).func_174888_l();
            ((ChestTileEntity)te).func_189404_a(lootTable, rand.nextLong());
        } else {
            DimDungeons.LOGGER.info("DIMDUNGEONS: FAILED TO PLACE CHEST IN DUNGEON. pos = " + pos.func_177958_n() + ", " + pos.func_177952_p());
        }
    }

    private static void fillBarrelBelow(BlockPos pos, ResourceLocation lootTable, IWorld world, Random rand) {
        world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
        TileEntity te = world.func_175625_s(pos.func_177977_b());
        if (te instanceof BarrelTileEntity) {
            ((BarrelTileEntity)te).func_174888_l();
            ((BarrelTileEntity)te).func_189404_a(lootTable, rand.nextLong());
        } else {
            DimDungeons.LOGGER.info("DIMDUNGEONS: FAILED TO PLACE BARREL IN DUNGEON. pos = " + pos.func_177958_n() + ", " + pos.func_177952_p());
        }
    }

    private static ItemStack generateLuckyMessage(Random rand) {
        ItemStack stack = new ItemStack((IItemProvider)Items.field_151164_bB);
        stack.func_77982_d(new CompoundNBT());
        int messageVariation = rand.nextInt(8) + 1;
        String title = new TranslationTextComponent("book.dimdungeons.title_4", new Object[0]).getString();
        String body = new TranslationTextComponent("book.dimdungeons.advanced_message_" + messageVariation, new Object[0]).getString();
        ListNBT pages = new ListNBT();
        TranslationTextComponent text = new TranslationTextComponent(body, new Object[0]);
        String json = ITextComponent.Serializer.func_150696_a((ITextComponent)text);
        pages.add(0, (INBT)StringNBT.func_229705_a_((String)json));
        stack.func_77978_p().func_74757_a("resolved", false);
        stack.func_77978_p().func_74768_a("generation", 0);
        stack.func_77978_p().func_218657_a("pages", (INBT)pages);
        stack.func_77978_p().func_74778_a("title", title);
        stack.func_77978_p().func_74778_a("author", new TranslationTextComponent("book.dimdungeons.author", new Object[0]).getString());
        return stack;
    }

    private static void LockDispensersAround(IWorld world, BlockPos pos) {
    }

    private static void faceContainerTowardsAir(IWorld world, BlockPos pos) {
        BlockState bs = world.func_180495_p(pos);
        if (bs.func_177230_c() == Blocks.field_150367_z || bs.func_177230_c() == Blocks.field_150486_ae) {
            if (world.func_180495_p(pos.func_177978_c()).func_177230_c() == Blocks.field_150350_a) {
                // empty if block
            }
            if (world.func_180495_p(pos.func_177968_d()).func_177230_c() == Blocks.field_150350_a) {
                // empty if block
            }
            if (world.func_180495_p(pos.func_177976_e()).func_177230_c() == Blocks.field_150350_a) {
                // empty if block
            }
            if (world.func_180495_p(pos.func_177974_f()).func_177230_c() == Blocks.field_150350_a) {
                // empty if block
            }
            world.func_180501_a(pos, bs, 2);
        }
    }
}

