/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.client;

import javax.annotation.Nonnull;
import mcjty.lib.network.NetworkTools;
import mcjty.rftoolsbase.api.xnet.channels.IChannelType;
import mcjty.xnet.XNet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;

public class ControllerChannelClientInfo {
    @Nonnull
    private final String channelName;
    @Nonnull
    private final String publishedName;
    @Nonnull
    private final BlockPos pos;
    @Nonnull
    private final IChannelType channelType;
    private final boolean remote;
    private final int index;

    public ControllerChannelClientInfo(@Nonnull String channelName, @Nonnull String publishedName, @Nonnull BlockPos pos, @Nonnull IChannelType channelType, boolean remote, int index) {
        this.channelName = channelName;
        this.publishedName = publishedName;
        this.pos = pos;
        this.channelType = channelType;
        this.remote = remote;
        this.index = index;
    }

    public ControllerChannelClientInfo(@Nonnull PacketBuffer buf) {
        this.channelName = NetworkTools.readStringUTF8((PacketBuffer)buf);
        this.publishedName = NetworkTools.readStringUTF8((PacketBuffer)buf);
        String id = buf.func_150789_c(Short.MAX_VALUE);
        IChannelType t = XNet.xNetApi.findType(id);
        if (t == null) {
            throw new RuntimeException("Bad type: " + id);
        }
        this.channelType = t;
        this.pos = buf.func_179259_c();
        this.remote = buf.readBoolean();
        this.index = buf.readInt();
    }

    public void writeToNBT(@Nonnull PacketBuffer buf) {
        NetworkTools.writeStringUTF8((PacketBuffer)buf, (String)this.channelName);
        NetworkTools.writeStringUTF8((PacketBuffer)buf, (String)this.publishedName);
        buf.func_180714_a(this.channelType.getID());
        buf.func_179255_a(this.pos);
        buf.writeBoolean(this.remote);
        buf.writeInt(this.index);
    }

    @Nonnull
    public String getChannelName() {
        return this.channelName;
    }

    @Nonnull
    public String getPublishedName() {
        return this.publishedName;
    }

    @Nonnull
    public BlockPos getPos() {
        return this.pos;
    }

    @Nonnull
    public IChannelType getChannelType() {
        return this.channelType;
    }

    public int getIndex() {
        return this.index;
    }

    public boolean isRemote() {
        return this.remote;
    }
}

