/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.ftbchunks.net;

import com.feed_the_beast.mods.ftbchunks.api.Waypoint;
import com.feed_the_beast.mods.ftbchunks.impl.ClaimedChunkPlayerDataImpl;
import com.feed_the_beast.mods.ftbchunks.impl.FTBChunksAPIImpl;
import com.feed_the_beast.mods.ftbchunks.net.SendWaypointsPacket;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class ChangeWaypointNamePacket {
    public final UUID id;
    public final String name;

    public ChangeWaypointNamePacket(UUID w, String c) {
        this.id = w;
        this.name = c;
    }

    ChangeWaypointNamePacket(PacketBuffer buf) {
        this.id = new UUID(buf.readLong(), buf.readLong());
        this.name = buf.func_150789_c(100);
    }

    void write(PacketBuffer buf) {
        buf.writeLong(this.id.getMostSignificantBits());
        buf.writeLong(this.id.getLeastSignificantBits());
        buf.func_211400_a(this.name, 100);
    }

    void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            ServerPlayerEntity p = ((NetworkEvent.Context)context.get()).getSender();
            ClaimedChunkPlayerDataImpl data = FTBChunksAPIImpl.manager.getData(p);
            Waypoint w = data.waypoints.get(this.id);
            if (w != null) {
                w.name = this.name;
                data.save();
                SendWaypointsPacket.send(p);
            }
        });
        context.get().setPacketHandled(true);
    }
}

