/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.ftbchunks.impl.map;

import com.feed_the_beast.mods.ftbchunks.FTBChunks;
import com.feed_the_beast.mods.ftbchunks.impl.map.MapChunk;
import com.feed_the_beast.mods.ftbchunks.impl.map.MapDimension;
import com.feed_the_beast.mods.ftbchunks.impl.map.XZ;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import net.minecraft.world.World;

public class MapRegion {
    public final MapDimension dimension;
    public final XZ pos;
    public final Map<XZ, MapChunk> chunks;
    private boolean save;
    public long lastAccess = 0L;
    private BufferedImage image;

    MapRegion(MapDimension d, XZ p) {
        this.dimension = d;
        this.pos = p;
        this.chunks = new HashMap<XZ, MapChunk>();
        this.save = false;
    }

    public MapRegion load() {
        BufferedImage image = this.getImage();
        for (int cz = 0; cz < 32; ++cz) {
            for (int cx = 0; cx < 32; ++cx) {
                if (image.getRGB(cx * 16, cz * 16) == 0) continue;
                MapChunk chunk = new MapChunk(this, XZ.of(cx, cz));
                this.chunks.put(chunk.pos, chunk);
            }
        }
        FTBChunks.LOGGER.debug("Loaded region " + this.pos + " - " + this.chunks.size() + " chunks");
        return this;
    }

    public BufferedImage getImage() {
        if (this.image == null) {
            Path file = this.dimension.directory.resolve(this.pos.x + "," + this.pos.z + ",map.png");
            if (Files.exists(file, new LinkOption[0])) {
                try (InputStream is = Files.newInputStream(file, new OpenOption[0]);){
                    this.image = ImageIO.read(is);
                    if (this.image.getWidth() != 512 || this.image.getHeight() != 512) {
                        this.image = null;
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            if (this.image == null) {
                this.image = new BufferedImage(512, 512, 2);
            }
        }
        return this.image;
    }

    public MapRegion access() {
        this.lastAccess = System.currentTimeMillis();
        return this;
    }

    public MapChunk getChunk(XZ chunkPos) {
        if (chunkPos.x != (chunkPos.x & 0x1F) || chunkPos.z != (chunkPos.z & 0x1F)) {
            chunkPos = XZ.of(chunkPos.x & 0x1F, chunkPos.z & 0x1F);
        }
        return this.chunks.computeIfAbsent(chunkPos, p -> new MapChunk(this, (XZ)p));
    }

    public void save() {
        this.save = true;
    }

    public boolean saveNow() {
        for (MapChunk chunk : this.chunks.values()) {
            if (!chunk.weakUpdate) continue;
            this.dimension.manager.queueSend((World)this.dimension.manager.manager.server.func_71218_a(this.dimension.dimension), chunk.getActualPos(), serverPlayerEntity -> true);
            chunk.weakUpdate = false;
        }
        if (!this.save) {
            return true;
        }
        this.save = false;
        if (Files.notExists(this.dimension.directory, new LinkOption[0])) {
            try {
                Files.createDirectories(this.dimension.directory, new FileAttribute[0]);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        try (OutputStream out = Files.newOutputStream(this.dimension.directory.resolve(this.pos.x + "," + this.pos.z + ",map.png"), new OpenOption[0]);){
            ImageIO.write((RenderedImage)this.getImage(), "PNG", out);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        FTBChunks.LOGGER.debug("Saved region " + this.pos + " - " + this.chunks.size() + " chunks");
        return false;
    }
}

