/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.ftbchunks.client.map;

import com.feed_the_beast.mods.ftbchunks.api.Waypoint;
import com.feed_the_beast.mods.ftbchunks.client.map.ClientMapChunk;
import com.feed_the_beast.mods.ftbchunks.client.map.ClientMapManager;
import com.feed_the_beast.mods.ftbchunks.client.map.ClientMapRegion;
import com.feed_the_beast.mods.ftbchunks.impl.map.XZ;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.dimension.DimensionType;

public class ClientMapDimension {
    public static ClientMapDimension current;
    public final ClientMapManager manager;
    public final DimensionType dimension;
    public final Path directory;
    public final HashMap<XZ, ClientMapRegion> regions;
    public final List<Waypoint> waypoints;

    public ClientMapDimension(ClientMapManager m, DimensionType d) {
        this.manager = m;
        this.dimension = d;
        ResourceLocation id = DimensionType.func_212678_a((DimensionType)this.dimension);
        this.directory = this.manager.directory.resolve(id.func_110624_b() + "_" + id.func_110623_a());
        this.regions = new HashMap();
        this.waypoints = new ArrayList<Waypoint>();
    }

    public ClientMapRegion getRegion(XZ pos) {
        return this.regions.computeIfAbsent(pos, p -> new ClientMapRegion(this, (XZ)p).load());
    }

    public void release() {
        for (ClientMapRegion region : this.regions.values()) {
            region.release();
        }
        this.regions.clear();
        this.waypoints.clear();
    }

    public ClientMapChunk getChunk(XZ pos) {
        return this.getRegion(XZ.regionFromChunk(pos.x, pos.z)).getChunk(pos);
    }
}

