/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.ftbchunks.api;

import com.feed_the_beast.mods.ftbchunks.api.ChunkDimPos;
import com.feed_the_beast.mods.ftbchunks.api.ClaimResult;
import com.feed_the_beast.mods.ftbchunks.api.ClaimedChunkGroup;
import com.feed_the_beast.mods.ftbchunks.api.ClaimedChunkPlayerData;
import java.time.Instant;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;

public interface ClaimedChunk
extends ClaimResult {
    public ClaimedChunkPlayerData getPlayerData();

    public ChunkDimPos getPos();

    @Nullable
    public Instant getForceLoadedTime();

    default public boolean isForceLoaded() {
        return this.getForceLoadedTime() != null;
    }

    @Nullable
    public ClaimedChunkGroup getGroup();

    default public String getGroupID() {
        ClaimedChunkGroup g = this.getGroup();
        return g == null ? "" : g.getId();
    }

    public Instant getTimeClaimed();

    @Override
    default public boolean isSuccess() {
        return true;
    }

    default public int getColor() {
        int c = this.getGroup() == null ? 0 : this.getGroup().getColorOverride();
        return c == 0 ? this.getPlayerData().getColor() : c;
    }

    public boolean canEdit(ServerPlayerEntity var1, BlockState var2);

    public boolean canInteract(ServerPlayerEntity var1, BlockState var2);

    public boolean canEntitySpawn(Entity var1);

    public boolean allowExplosions();

    default public ITextComponent getDisplayName() {
        ClaimedChunkGroup group = this.getGroup();
        if (group != null && group.getCustomName() != null) {
            return group.getCustomName();
        }
        return this.getPlayerData().getDisplayName();
    }
}

