/*
 * Decompiled with CFR 0.152.
 */
package cofh.ensorcellation.enchantment.override;

import cofh.lib.enchantment.EnchantmentOverride;
import cofh.lib.util.helpers.MathHelper;
import cofh.lib.util.references.CoreReferences;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.material.Material;
import net.minecraft.dispenser.IPosition;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.HorseArmorItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.ForgeEventFactory;

public class FrostWalkerEnchantmentImp
extends EnchantmentOverride {
    private static boolean freezeLava = true;

    public FrostWalkerEnchantmentImp() {
        super(Enchantment.Rarity.RARE, EnchantmentType.ARMOR_FEET, new EquipmentSlotType[]{EquipmentSlotType.FEET});
        this.maxLevel = 2;
        this.treasure = true;
    }

    public int func_77321_a(int level) {
        return level * 10;
    }

    public int func_223551_b(int level) {
        return this.func_77321_a(level) + 15;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        if (!this.enable) {
            return super.canApplyAtEnchantingTable(stack);
        }
        Item item = stack.func_77973_b();
        return this.enable && (this.field_77351_y != null && this.field_77351_y.func_77557_a(item) || item instanceof HorseArmorItem || this.supportsEnchantment(stack));
    }

    public boolean func_77326_a(Enchantment ench) {
        return super.func_77326_a(ench) && ench != Enchantments.field_185300_i;
    }

    public static void freezeNearby(LivingEntity living, World worldIn, BlockPos pos, int level) {
        if (!freezeLava) {
            return;
        }
        if (living.field_70122_E && CoreReferences.GLOSSED_MAGMA != null) {
            BlockState state = CoreReferences.GLOSSED_MAGMA.func_176223_P();
            float f = Math.min(16, 2 + level);
            BlockPos.Mutable mutable = new BlockPos.Mutable();
            for (BlockPos blockpos : BlockPos.func_218278_a((BlockPos)pos.func_177963_a((double)(-f), -1.0, (double)(-f)), (BlockPos)pos.func_177963_a((double)f, -1.0, (double)f))) {
                boolean isFull;
                if (!blockpos.func_218137_a((IPosition)living.func_213303_ch(), (double)f)) continue;
                mutable.func_181079_c(blockpos.func_177958_n(), blockpos.func_177956_o() + 1, blockpos.func_177952_p());
                BlockState blockstate1 = worldIn.func_180495_p((BlockPos)mutable);
                if (!blockstate1.isAir((IBlockReader)worldIn, (BlockPos)mutable)) continue;
                BlockState blockstate2 = worldIn.func_180495_p(blockpos);
                boolean bl = isFull = blockstate2.func_177230_c() == Blocks.field_150353_l && (Integer)blockstate2.func_177229_b((IProperty)FlowingFluidBlock.field_176367_b) == 0;
                if (blockstate2.func_185904_a() != Material.field_151587_i || !isFull || !state.func_196955_c((IWorldReader)worldIn, blockpos) || !worldIn.func_226663_a_(state, blockpos, ISelectionContext.func_216377_a()) || ForgeEventFactory.onBlockPlace((Entity)living, (BlockSnapshot)new BlockSnapshot((IWorld)worldIn, blockpos, blockstate2), (Direction)Direction.UP)) continue;
                worldIn.func_175656_a(blockpos, state);
                worldIn.func_205220_G_().func_205360_a(blockpos, (Object)CoreReferences.GLOSSED_MAGMA, MathHelper.nextInt((Random)living.func_70681_au(), (int)60, (int)120));
            }
        }
    }

    public void setFreezeLava(boolean freezeLava) {
        FrostWalkerEnchantmentImp.freezeLava = freezeLava;
        this.field_77350_z = "enchantment." + (freezeLava ? "ensorcellation.frost_walker" : "minecraft.frost_walker");
    }
}

