/*
 * Decompiled with CFR 0.152.
 */
package cofh.ensorcellation.enchantment;

import cofh.lib.enchantment.EnchantmentCoFH;
import cofh.lib.util.Utils;
import cofh.lib.util.references.CoreReferences;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.BlazeEntity;
import net.minecraft.entity.monster.MagmaCubeEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.AxeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SwordItem;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class FrostAspectEnchantment
extends EnchantmentCoFH {
    public FrostAspectEnchantment() {
        super(Enchantment.Rarity.RARE, EnchantmentType.WEAPON, new EquipmentSlotType[]{EquipmentSlotType.MAINHAND});
        this.maxLevel = 2;
    }

    public int func_77321_a(int level) {
        return 10 + 20 * (level - 1);
    }

    protected int maxDelegate(int level) {
        return super.func_77321_a(level) + 50;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        Item item = stack.func_77973_b();
        return this.enable && (item instanceof SwordItem || item instanceof AxeItem || this.supportsEnchantment(stack));
    }

    public boolean func_77326_a(Enchantment ench) {
        return super.func_77326_a(ench) && ench != Enchantments.field_77334_n;
    }

    public static boolean validTarget(Entity entity) {
        return entity instanceof BlazeEntity || entity instanceof MagmaCubeEntity;
    }

    public static float getExtraDamage(int level) {
        return (float)level * 2.5f;
    }

    public static void onHit(LivingEntity entity, int level) {
        int i = 80 * level;
        if (entity.func_70027_ad()) {
            entity.func_70066_B();
        }
        entity.func_195064_c(new EffectInstance(CoreReferences.CHILLED, i, level - 1, false, false));
        if (entity.field_70170_p instanceof ServerWorld) {
            for (int j = 0; j < 4 * level; ++j) {
                Utils.spawnParticles((World)entity.field_70170_p, (IParticleData)ParticleTypes.field_197593_D, (double)(entity.func_226277_ct_() + entity.field_70170_p.field_73012_v.nextDouble()), (double)(entity.func_226278_cu_() + 1.0 + entity.field_70170_p.field_73012_v.nextDouble()), (double)(entity.func_226281_cx_() + entity.field_70170_p.field_73012_v.nextDouble()), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
            }
        }
    }
}

