/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.citadel.server.entity;

import com.github.alexthe666.citadel.Citadel;
import com.github.alexthe666.citadel.server.entity.EntityDataHandler;
import com.github.alexthe666.citadel.server.entity.EntityProperties;
import com.github.alexthe666.citadel.server.entity.IEntityData;
import com.github.alexthe666.citadel.server.entity.PropertiesTracker;
import com.github.alexthe666.citadel.server.entity.WeakIdentityHashMap;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;

public enum EntityPropertiesHandler {
    INSTANCE;

    private Map<Class<? extends EntityProperties>, String> propertiesIDMap = new HashMap<Class<? extends EntityProperties>, String>();
    private Map<Class<? extends Entity>, List<Class<? extends EntityProperties<?>>>> registeredProperties = new HashMap();
    private Map<Class<? extends Entity>, List<String>> entityPropertiesCache = new HashMap<Class<? extends Entity>, List<String>>();
    private Map<ServerPlayerEntity, List<PropertiesTracker<?>>> trackerMap = new WeakIdentityHashMap();

    public <E extends Entity, T extends EntityProperties<E>> void registerProperties(Class<T> propertiesClass) {
        EntityProperties properties;
        try {
            Constructor<T> constructor = propertiesClass.getConstructor(new Class[0]);
            properties = (EntityProperties)constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            Citadel.LOGGER.fatal("Failed to register entity properties", (Throwable)e);
            return;
        }
        if (this.propertiesIDMap.containsValue(properties.getID())) {
            Citadel.LOGGER.fatal("Duplicate entity properties with ID {}", (Object)properties.getID());
            return;
        }
        this.propertiesIDMap.put(propertiesClass, properties.getID());
        Class entityClass = properties.getEntityClass();
        List list = this.registeredProperties.computeIfAbsent(entityClass, k -> new ArrayList());
        list.add(propertiesClass);
    }

    public <T extends EntityProperties<?>> T getProperties(Entity entity, Class<T> propertiesClass) {
        if (entity != null && this.propertiesIDMap.containsKey(propertiesClass)) {
            return (T)((EntityProperties)EntityDataHandler.INSTANCE.getEntityData(entity, this.propertiesIDMap.get(propertiesClass)));
        }
        return null;
    }

    public <T extends Entity> void addTracker(ServerPlayerEntity player, T entity) {
        List<String> entityProperties = this.entityPropertiesCache.get(entity.getClass());
        if (entityProperties != null) {
            List trackerList = this.trackerMap.computeIfAbsent(player, k -> new ArrayList());
            for (String propID : entityProperties) {
                EntityProperties properties;
                IEntityData<T> extendedProperties = EntityDataHandler.INSTANCE.getEntityData(entity, propID);
                if (!(extendedProperties instanceof EntityProperties) || (properties = (EntityProperties)extendedProperties).getTrackingTime() < 0) continue;
                PropertiesTracker<T> tracker = properties.createTracker(entity);
                tracker.setReady();
                trackerList.add(tracker);
            }
        }
    }

    public void removeTracker(ServerPlayerEntity player, Entity entity) {
        List<PropertiesTracker<?>> trackerList = this.trackerMap.get(player);
        if (trackerList != null && trackerList.size() > 0) {
            Iterator<PropertiesTracker<?>> iterator = trackerList.iterator();
            while (iterator.hasNext()) {
                PropertiesTracker<?> tracker = iterator.next();
                if (!tracker.getEntity().equals((Object)entity)) continue;
                iterator.remove();
                tracker.removeTracker();
            }
        }
    }

    public boolean hasEntityInCache(Class<? extends Entity> entityClass) {
        return this.entityPropertiesCache.containsKey(entityClass);
    }

    public void addEntityToCache(Class<? extends Entity> entityClass, List<String> propertyIDs) {
        this.entityPropertiesCache.put(entityClass, propertyIDs);
    }

    public Stream<Map.Entry<Class<? extends Entity>, List<Class<? extends EntityProperties<?>>>>> getRegisteredProperties() {
        return this.registeredProperties.entrySet().stream();
    }

    public List<PropertiesTracker<?>> getEntityTrackers(ServerPlayerEntity player) {
        return this.trackerMap.get(player);
    }

    public Iterator<Map.Entry<ServerPlayerEntity, List<PropertiesTracker<?>>>> getTrackerIterator() {
        return this.trackerMap.entrySet().iterator();
    }
}

