/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.api.tinkering;

import com.blakebr0.mysticalagriculture.api.lib.AbilityCache;
import com.blakebr0.mysticalagriculture.api.tinkering.AugmentType;
import com.google.common.collect.Multimap;
import java.util.EnumSet;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingFallEvent;

public interface IAugment {
    public ResourceLocation getId();

    default public String getName() {
        return this.getId().func_110623_a();
    }

    default public String getNameWithSuffix(String suffix) {
        return String.format("%s_%s", this.getName(), suffix);
    }

    default public ITextComponent getDisplayName() {
        return new TranslationTextComponent(String.format("augment.%s.%s", this.getModId(), this.getName()), new Object[0]);
    }

    default public String getModId() {
        return this.getId().func_110624_b();
    }

    public EnumSet<AugmentType> getAugmentTypes();

    public int getTier();

    public Item getItem();

    public int getPrimaryColor();

    public int getSecondaryColor();

    default public boolean hasEffect() {
        return this.getTier() >= 5;
    }

    public boolean isEnabled();

    public void setEnabled(boolean var1);

    default public boolean onItemUse(ItemUseContext context) {
        return false;
    }

    default public boolean onRightClick(ItemStack stack, World world, PlayerEntity player, Hand hand) {
        return false;
    }

    default public boolean onRightClickEntity(ItemStack stack, PlayerEntity player, LivingEntity target, Hand hand) {
        return false;
    }

    default public boolean onHitEntity(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        return false;
    }

    default public boolean onBlockDestroyed(ItemStack stack, World world, BlockState state, BlockPos pos, LivingEntity entity) {
        return false;
    }

    default public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, PlayerEntity player) {
        return false;
    }

    default public void onInventoryTick(ItemStack stack, World world, Entity entity, int slot, boolean isSelected) {
    }

    default public void onArmorTick(ItemStack stack, World world, PlayerEntity player) {
    }

    default public void onPlayerTick(World world, PlayerEntity player, AbilityCache cache) {
    }

    default public void onPlayerFall(World world, PlayerEntity player, LivingFallEvent event) {
    }

    default public void addToolAttributeModifiers(Multimap<String, AttributeModifier> attributes, EquipmentSlotType slot, ItemStack stack) {
    }

    default public void addArmorAttributeModifiers(Multimap<String, AttributeModifier> attributes, EquipmentSlotType slot, ItemStack stack) {
    }
}

