/*
 * Decompiled with CFR 0.152.
 */
package jeresources.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import jeresources.api.drop.LootDrop;
import jeresources.compatibility.CompatBase;
import jeresources.util.MobTableBuilder;
import jeresources.util.ReflectionHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.SheepEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.resources.SimpleReloadableResourceManager;
import net.minecraft.resources.VanillaPack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Unit;
import net.minecraft.util.Util;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.ItemLootEntry;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootPredicateManager;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableManager;
import net.minecraft.world.storage.loot.LootTables;
import net.minecraft.world.storage.loot.StandaloneLootEntry;
import net.minecraft.world.storage.loot.TableLootEntry;
import net.minecraft.world.storage.loot.conditions.ILootCondition;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.moddiscovery.ModFileInfo;
import net.minecraftforge.fml.packs.ModFileResourcePack;
import net.minecraftforge.registries.ForgeRegistries;

public class LootTableHelper {
    private static final Map<DyeColor, ResourceLocation> sheepColors = new HashMap<DyeColor, ResourceLocation>();
    private static LootTableManager manager;

    public static List<LootPool> getPools(LootTable table) {
        return (List)ReflectionHelper.getPrivateValue(LootTable.class, (Object)table, (String)"field_186466_c");
    }

    public static List<LootEntry> getLootEntries(LootPool pool) {
        return (List)ReflectionHelper.getPrivateValue(LootPool.class, (Object)pool, (String)"field_186453_a");
    }

    public static List<ILootCondition> getLootConditions(LootPool pool) {
        return (List)ReflectionHelper.getPrivateValue(LootPool.class, (Object)pool, (String)"field_186454_b");
    }

    public static List<LootDrop> toDrops(LootTable table) {
        ArrayList<LootDrop> drops = new ArrayList<LootDrop>();
        LootTableManager manager = LootTableHelper.getManager();
        LootTableHelper.getPools(table).forEach(pool -> {
            float totalWeight = LootTableHelper.getLootEntries(pool).stream().filter(entry -> entry instanceof StandaloneLootEntry).map(entry -> (StandaloneLootEntry)entry).mapToInt(entry -> entry.field_216158_e).sum();
            List<ILootCondition> poolConditions = LootTableHelper.getLootConditions(pool);
            LootTableHelper.getLootEntries(pool).stream().filter(entry -> entry instanceof ItemLootEntry).map(entry -> (ItemLootEntry)entry).map(entry -> new LootDrop(entry.field_186368_a, (float)entry.field_216158_e / totalWeight, entry.field_216144_d, entry.field_216160_g)).map(drop -> drop.addLootConditions(poolConditions)).forEach(drops::add);
            LootTableHelper.getLootEntries(pool).stream().filter(entry -> entry instanceof TableLootEntry).map(entry -> (TableLootEntry)entry).map(entry -> LootTableHelper.toDrops(manager.func_186521_a(entry.field_186371_a))).forEach(drops::addAll);
        });
        drops.removeIf(Objects::isNull);
        return drops;
    }

    public static List<LootDrop> toDrops(World world, ResourceLocation lootTable) {
        return LootTableHelper.toDrops(LootTableHelper.getManager(world).func_186521_a(lootTable));
    }

    public static List<ResourceLocation> getAllChestLootTablesResourceLocations() {
        ArrayList<ResourceLocation> chestTables = new ArrayList<ResourceLocation>();
        chestTables.add(LootTables.field_186421_c);
        chestTables.add(LootTables.field_186422_d);
        chestTables.add(LootTables.field_215814_e);
        chestTables.add(LootTables.field_215815_f);
        chestTables.add(LootTables.field_215816_g);
        chestTables.add(LootTables.field_215817_h);
        chestTables.add(LootTables.field_215818_i);
        chestTables.add(LootTables.field_215819_j);
        chestTables.add(LootTables.field_215820_k);
        chestTables.add(LootTables.field_215821_l);
        chestTables.add(LootTables.field_215822_m);
        chestTables.add(LootTables.field_215823_n);
        chestTables.add(LootTables.field_215824_o);
        chestTables.add(LootTables.field_215825_p);
        chestTables.add(LootTables.field_215826_q);
        chestTables.add(LootTables.field_215827_r);
        chestTables.add(LootTables.field_215828_s);
        chestTables.add(LootTables.field_215829_t);
        chestTables.add(LootTables.field_186424_f);
        chestTables.add(LootTables.field_186425_g);
        chestTables.add(LootTables.field_186426_h);
        chestTables.add(LootTables.field_186427_i);
        chestTables.add(LootTables.field_186428_j);
        chestTables.add(LootTables.field_186429_k);
        chestTables.add(LootTables.field_186430_l);
        chestTables.add(LootTables.field_186431_m);
        chestTables.add(LootTables.field_191192_o);
        chestTables.add(LootTables.field_204114_p);
        chestTables.add(LootTables.field_204115_q);
        chestTables.add(LootTables.field_204312_r);
        chestTables.add(LootTables.field_204771_s);
        chestTables.add(LootTables.field_204772_t);
        chestTables.add(LootTables.field_204773_u);
        chestTables.add(LootTables.field_215813_K);
        return chestTables;
    }

    public static Map<ResourceLocation, LivingEntity> getAllMobLootTables(World world) {
        MobTableBuilder mobTableBuilder = new MobTableBuilder(world);
        for (Map.Entry<DyeColor, ResourceLocation> entry : sheepColors.entrySet()) {
            ResourceLocation lootTableList = entry.getValue();
            DyeColor dyeColor = entry.getKey();
            mobTableBuilder.addSheep(lootTableList, (EntityType<SheepEntity>)EntityType.field_200737_ac, dyeColor);
        }
        for (EntityType entityType : ForgeRegistries.ENTITIES) {
            if (entityType.func_220339_d() == EntityClassification.MISC) continue;
            mobTableBuilder.add(entityType.func_220348_g(), entityType);
        }
        return mobTableBuilder.getMobTables();
    }

    public static LootTableManager getManager(@Nullable World world) {
        if (world == null || world.func_73046_m() == null) {
            if (manager == null) {
                manager = new LootTableManager(new LootPredicateManager());
                SimpleReloadableResourceManager serverResourceManger = new SimpleReloadableResourceManager(ResourcePackType.SERVER_DATA, Minecraft.func_71410_x().func_213170_ax());
                LinkedList<Object> packs = new LinkedList<Object>();
                packs.add(new VanillaPack(new String[]{"minecraft"}));
                for (ModFileInfo mod : ModList.get().getModFiles()) {
                    packs.add(new ModFileResourcePack(mod.getFile()));
                }
                packs.forEach(arg_0 -> ((SimpleReloadableResourceManager)serverResourceManger).func_199021_a(arg_0));
                serverResourceManger.func_219534_a((IFutureReloadListener)manager);
                CompletableFuture completableFuture = serverResourceManger.func_219536_a(Util.func_215072_e(), (Executor)Minecraft.func_71410_x(), packs, CompletableFuture.completedFuture(Unit.INSTANCE));
                Minecraft.func_71410_x().func_213161_c(completableFuture::isDone);
            }
            return manager;
        }
        return world.func_73046_m().func_200249_aQ();
    }

    public static LootTableManager getManager() {
        return LootTableHelper.getManager(CompatBase.getWorld());
    }

    static {
        sheepColors.put(DyeColor.WHITE, LootTables.field_186404_L);
        sheepColors.put(DyeColor.ORANGE, LootTables.field_186405_M);
        sheepColors.put(DyeColor.MAGENTA, LootTables.field_186406_N);
        sheepColors.put(DyeColor.LIGHT_BLUE, LootTables.field_186407_O);
        sheepColors.put(DyeColor.YELLOW, LootTables.field_186408_P);
        sheepColors.put(DyeColor.LIME, LootTables.field_186409_Q);
        sheepColors.put(DyeColor.PINK, LootTables.field_186410_R);
        sheepColors.put(DyeColor.GRAY, LootTables.field_186411_S);
        sheepColors.put(DyeColor.LIGHT_GRAY, LootTables.field_197738_Y);
        sheepColors.put(DyeColor.CYAN, LootTables.field_186413_U);
        sheepColors.put(DyeColor.PURPLE, LootTables.field_186414_V);
        sheepColors.put(DyeColor.BLUE, LootTables.field_186415_W);
        sheepColors.put(DyeColor.BROWN, LootTables.field_186416_X);
        sheepColors.put(DyeColor.GREEN, LootTables.field_186417_Y);
        sheepColors.put(DyeColor.RED, LootTables.field_186418_Z);
        sheepColors.put(DyeColor.BLACK, LootTables.field_186376_aa);
    }
}

