/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.mixin.ai.fast_brain;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.brain.Brain;
import net.minecraft.entity.ai.brain.memory.MemoryModuleStatus;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.schedule.Activity;
import net.minecraft.entity.ai.brain.sensor.Sensor;
import net.minecraft.entity.ai.brain.sensor.SensorType;
import net.minecraft.entity.ai.brain.task.Task;
import net.minecraft.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Brain.class})
public abstract class MixinBrain<E extends LivingEntity> {
    @Shadow
    @Final
    private Map<SensorType<? extends Sensor<? super E>>, Sensor<? super E>> field_218231_b;
    @Shadow
    @Final
    private Map<Integer, Map<Activity, Set<Task<? super E>>>> field_218232_c;
    @Shadow
    @Final
    private Set<Activity> field_218236_g;
    private final List<Pair<Activity, List<Task<? super E>>>> allTasks = new ArrayList<Pair<Activity, List<Task<? super E>>>>();

    @Inject(method={"registerActivity(Lnet/minecraft/entity/ai/brain/schedule/Activity;Lcom/google/common/collect/ImmutableList;Ljava/util/Set;)V"}, at={@At(value="RETURN")})
    private void onTaskListUpdated(Activity activity, ImmutableList<Pair<Integer, ? extends Task<? super E>>> immutableList_1, Set<Pair<MemoryModuleType<?>, MemoryModuleStatus>> set_1, CallbackInfo ci) {
        this.allTasks.clear();
        for (Map<Activity, Set<Task<E>>> map : this.field_218232_c.values()) {
            for (Map.Entry<Activity, Set<Task<E>>> entry : map.entrySet()) {
                this.allTasks.add(Pair.of((Object)entry.getKey(), new ArrayList(entry.getValue())));
            }
        }
    }

    @Overwrite
    private void func_218229_c(ServerWorld world, E entity) {
        for (Sensor<? super E> sensor : this.field_218231_b.values()) {
            sensor.func_220973_b(world, entity);
        }
    }

    @Overwrite
    private void func_218218_d(ServerWorld world, E entity) {
        long time = world.func_82737_E();
        for (Pair<Activity, List<Task<? super E>>> pair : this.allTasks) {
            if (!this.field_218236_g.contains(pair.getFirst())) continue;
            for (Task task : (List)pair.getSecond()) {
                if (task.func_220376_b() != Task.Status.STOPPED) continue;
                task.func_220378_b(world, entity, time);
            }
        }
    }

    @Overwrite
    private void func_218222_e(ServerWorld world, E entity) {
        long time = world.func_82737_E();
        for (Pair<Activity, List<Task<? super E>>> pair : this.allTasks) {
            for (Task task : (List)pair.getSecond()) {
                if (task.func_220376_b() != Task.Status.RUNNING) continue;
                task.func_220377_c(world, entity, time);
            }
        }
    }
}

