/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.asm;

import cpw.mods.modlauncher.api.INameMappingService;
import java.util.Objects;
import me.jellysquid.mods.lithium.asm.NameUtil;

public class FieldRef {
    public final String owner;
    public final String name;
    public final String desc;

    public FieldRef(String owner, String name, String desc) {
        this.owner = owner;
        this.name = name;
        this.desc = desc;
    }

    public static FieldRef intermediary(String owner, String name, String desc) {
        String className = NameUtil.deobfName(INameMappingService.Domain.CLASS, owner);
        String fieldName = NameUtil.deobfName(INameMappingService.Domain.FIELD, name);
        return new FieldRef(className, fieldName, desc);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other != null && this.getClass() == other.getClass()) {
            FieldRef ref = (FieldRef)other;
            return Objects.equals(this.name, ref.name) && Objects.equals(this.desc, ref.desc) && Objects.equals(this.owner, ref.owner);
        }
        return false;
    }

    public int hashCode() {
        int h = this.name.hashCode();
        h = 31 * h + this.desc.hashCode();
        h = 31 * h + this.owner.hashCode();
        return h;
    }

    public String toString() {
        return String.format("FieldRef{owner='%s', name='%s', desc='%s'}", this.owner, this.name, this.desc);
    }
}

