/*
 * Decompiled with CFR 0.152.
 */
package com.github.commoble.tubesreloaded.common.routing;

import com.github.commoble.tubesreloaded.common.blocks.tube.TubeBlock;
import com.github.commoble.tubesreloaded.common.routing.Endpoint;
import com.github.commoble.tubesreloaded.common.routing.PosAndDist;
import com.github.commoble.tubesreloaded.common.routing.Route;
import com.github.commoble.tubesreloaded.common.routing.RoutingNetwork;
import com.github.commoble.tubesreloaded.common.util.PosHelper;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.PriorityQueue;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class FastestRoutesSolver {
    public static List<Route> generateRoutes(RoutingNetwork network, World world, BlockPos startPos) {
        Object2IntOpenHashMap tubeDists = new Object2IntOpenHashMap();
        tubeDists.put((Object)startPos, 0);
        Object2IntOpenHashMap endpointDists = new Object2IntOpenHashMap();
        HashSet<BlockPos> visitedTubes = new HashSet<BlockPos>();
        HashSet<Endpoint> visitedEndpoints = new HashSet<Endpoint>();
        HashMap<BlockPos, BlockPos> tubePrevs = new HashMap<BlockPos, BlockPos>();
        HashMap<Endpoint, BlockPos> endpointPrevs = new HashMap<Endpoint, BlockPos>();
        PriorityQueue<PosAndDist> distQueue = new PriorityQueue<PosAndDist>(network.getSize());
        distQueue.add(new PosAndDist(startPos, 0));
        while (!distQueue.isEmpty()) {
            PosAndDist node = (PosAndDist)distQueue.poll();
            visitedTubes.add(node.pos);
            BlockState state = world.func_180495_p(node.pos);
            List<Direction> dirs = TubeBlock.getConnectedDirections(state);
            for (Direction face : dirs) {
                int newDist;
                BlockPos checkPos = node.pos.func_177972_a(face);
                Endpoint maybeEndpoint = new Endpoint(checkPos, face.func_176734_d());
                if (!visitedTubes.contains(checkPos) && network.tubes.contains(checkPos)) {
                    newDist = node.dist + 1;
                    if (!tubeDists.containsKey((Object)checkPos) || newDist < tubeDists.getInt((Object)checkPos)) {
                        tubeDists.put((Object)checkPos, newDist);
                        tubePrevs.put(checkPos, node.pos);
                    }
                    distQueue.add(new PosAndDist(checkPos, tubeDists.getInt((Object)checkPos)));
                    continue;
                }
                if (visitedEndpoints.contains(maybeEndpoint) || !network.endpoints.contains(maybeEndpoint)) continue;
                visitedEndpoints.add(maybeEndpoint);
                newDist = node.dist + 1;
                if (endpointDists.containsKey((Object)maybeEndpoint) && newDist >= endpointDists.getInt((Object)maybeEndpoint)) continue;
                endpointDists.put((Object)maybeEndpoint, newDist);
                endpointPrevs.put(maybeEndpoint, node.pos);
            }
        }
        ArrayList<Route> routes = new ArrayList<Route>(network.endpoints.size());
        for (Endpoint endpoint : network.endpoints) {
            LinkedList<Direction> sequenceOfMoves = FastestRoutesSolver.getSequenceOfMoves(endpoint, startPos, new LinkedList<Direction>(), tubePrevs, endpointPrevs);
            if (sequenceOfMoves == null) continue;
            routes.add(new Route(endpoint, sequenceOfMoves.size(), sequenceOfMoves));
        }
        routes.sort(null);
        return routes;
    }

    private static LinkedList<Direction> getSequenceOfMoves(Endpoint endpoint, BlockPos startPos, LinkedList<Direction> returnList, HashMap<BlockPos, BlockPos> tubePrevs, HashMap<Endpoint, BlockPos> endpointPrevs) {
        if (!endpointPrevs.containsKey(endpoint)) {
            return null;
        }
        BlockPos prevPos = endpointPrevs.get(endpoint);
        returnList.addFirst(endpoint.face.func_176734_d());
        if (prevPos.equals((Object)startPos)) {
            return returnList;
        }
        return FastestRoutesSolver.getSequenceOfMoves(prevPos, startPos, returnList, tubePrevs);
    }

    private static LinkedList<Direction> getSequenceOfMoves(BlockPos pos, BlockPos startPos, LinkedList<Direction> returnList, HashMap<BlockPos, BlockPos> prevs) {
        if (!prevs.containsKey(pos)) {
            return null;
        }
        BlockPos prevPos = prevs.get(pos);
        returnList.addFirst(PosHelper.getTravelDirectionFromTo(prevPos, pos));
        if (prevPos.equals((Object)startPos)) {
            return returnList;
        }
        return FastestRoutesSolver.getSequenceOfMoves(prevPos, startPos, returnList, prevs);
    }
}

