/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.libnonymous.gui.framework.widgets;

import com.davenonymous.libnonymous.gui.framework.GUIHelper;
import com.davenonymous.libnonymous.gui.framework.widgets.Widget;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.ResourceLocation;

public class WidgetImage
extends Widget {
    ResourceLocation image;
    float textureWidth = 16.0f;
    float textureHeight = 16.0f;
    Color color;
    float alpha = 1.0f;

    public WidgetImage(ResourceLocation image) {
        this.image = image;
    }

    public WidgetImage setTextureSize(float width, float height) {
        this.textureWidth = width;
        this.textureHeight = height;
        return this;
    }

    public WidgetImage setAlpha(float alpha) {
        this.alpha = alpha;
        return this;
    }

    public WidgetImage setColor(Color color) {
        this.alpha = color.getAlpha() / 255;
        this.color = color;
        return this;
    }

    public WidgetImage resetColor() {
        this.alpha = 1.0f;
        this.color = null;
        return this;
    }

    @Override
    public void draw(Screen screen) {
        RenderSystem.pushMatrix();
        RenderSystem.enableBlend();
        RenderSystem.enableAlphaTest();
        RenderSystem.translatef((float)0.0f, (float)0.0f, (float)2.0f);
        screen.getMinecraft().func_110434_K().func_110577_a(this.image);
        if (this.color == null) {
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        } else {
            float[] pColors = this.color.getRGBColorComponents(null);
            float pA = this.alpha;
            float pR = pColors[0];
            float pG = pColors[1];
            float pB = pColors[2];
            RenderSystem.color4f((float)pR, (float)pG, (float)pB, (float)pA);
        }
        this.actuallyDraw();
        RenderSystem.disableBlend();
        RenderSystem.disableAlphaTest();
        RenderSystem.popMatrix();
    }

    protected void actuallyDraw() {
        GUIHelper.drawModalRectWithCustomSizedTexture(0, 0, 0.0f, 0.0f, this.width * 2, this.height * 2, this.textureWidth, this.textureHeight);
    }
}

