/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.libnonymous.gui.framework;

import com.davenonymous.libnonymous.gui.framework.CircularPointedArrayList;
import com.davenonymous.libnonymous.gui.framework.WidgetSlot;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class WidgetContainer
extends Container {
    public static ResourceLocation SLOTGROUP_PLAYER = new ResourceLocation("libnonymous", "player_slots");
    private IItemHandler playerInventory;
    private CircularPointedArrayList<ResourceLocation> slotGroups;
    private Map<ResourceLocation, List<Integer>> slotGroupMap;
    private int nextSlotId = 0;

    protected WidgetContainer(@Nullable ContainerType<?> type, int id, PlayerInventory inv) {
        super(type, id);
        this.playerInventory = new InvWrapper((IInventory)inv);
        this.slotGroups = new CircularPointedArrayList();
        this.slotGroupMap = new HashMap<ResourceLocation, List<Integer>>();
    }

    protected Slot func_75146_a(Slot slotIn) {
        if (!(slotIn instanceof WidgetSlot)) {
            throw new RuntimeException("Only WidgetSlots are allowed in a WidgetContainer!");
        }
        ResourceLocation slotGroupId = ((WidgetSlot)slotIn).getGroupId();
        if (!this.slotGroups.contains(slotGroupId)) {
            this.slotGroups.add(slotGroupId);
        }
        if (!this.slotGroupMap.containsKey(slotGroupId)) {
            this.slotGroupMap.put(slotGroupId, new ArrayList());
        }
        this.slotGroupMap.get(slotGroupId).add(this.nextSlotId++);
        return super.func_75146_a(slotIn);
    }

    protected void lockSlot(int index) {
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot instanceof WidgetSlot) {
            ((WidgetSlot)slot).setLocked(true);
            this.field_75151_b.set(index, slot);
        }
    }

    protected int addSlotRange(ResourceLocation id, IItemHandler handler, int index, int x, int y, int amount, int dx) {
        for (int i = 0; i < amount; ++i) {
            this.func_75146_a((Slot)new WidgetSlot(id, handler, index, x, y));
            x += dx;
            ++index;
        }
        return index;
    }

    protected int addSlotBox(ResourceLocation id, IItemHandler handler, int index, int x, int y, int horAmount, int dx, int verAmount, int dy) {
        for (int j = 0; j < verAmount; ++j) {
            index = this.addSlotRange(id, handler, index, x, y, horAmount, dx);
            y += dy;
        }
        return index;
    }

    protected void layoutPlayerInventorySlots(int leftCol, int topRow) {
        this.addSlotBox(SLOTGROUP_PLAYER, this.playerInventory, 9, leftCol, topRow, 9, 18, 3, 18);
        this.addSlotRange(SLOTGROUP_PLAYER, this.playerInventory, 0, leftCol, topRow += 58, 9, 18);
    }

    private ArrayList<Integer> getTransferTargetSlots(ItemStack stack) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int groupIndex = 0; groupIndex < this.slotGroups.size(); ++groupIndex) {
            ResourceLocation targetGroup = this.slotGroups.next();
            List<Integer> slotsForThisGroup = this.slotGroupMap.get(targetGroup);
            for (int slotIndex : slotsForThisGroup) {
                ItemStack existingStack;
                WidgetSlot slot = (WidgetSlot)((Object)this.field_75151_b.get(slotIndex));
                if (!slot.func_111238_b() || slot.isLocked() || !slot.func_75214_a(stack) || slot.func_75216_d() && (!stack.func_77985_e() || !(existingStack = slot.func_75211_c()).func_77985_e() || existingStack.func_190916_E() >= existingStack.func_77976_d() || existingStack.func_190916_E() >= slot.func_75219_a() || existingStack.func_190916_E() >= slot.func_178170_b(existingStack) || !WidgetContainer.func_195929_a((ItemStack)stack, (ItemStack)existingStack))) continue;
                result.add(slotIndex);
            }
        }
        return result;
    }

    private int getSlotStackLimit(WidgetSlot slot, ItemStack stack) {
        int limit = Integer.MAX_VALUE;
        limit = Math.min(limit, slot.func_178170_b(stack));
        limit = Math.min(limit, slot.func_75219_a());
        limit = Math.min(limit, stack.func_77976_d());
        return limit;
    }

    private ItemStack insertStackIntoSlot(WidgetSlot slot, ItemStack stack) {
        ItemStack existingStack = slot.func_75211_c();
        int fitSize = this.getSlotStackLimit(slot, stack);
        int remainingSpace = fitSize - existingStack.func_190916_E();
        int toAddSize = stack.func_190916_E();
        int remaining = Math.max(0, toAddSize - remainingSpace);
        int inserted = toAddSize - remaining;
        ItemStack toInsert = stack.func_77946_l();
        toInsert.func_190920_e(inserted + existingStack.func_190916_E());
        slot.func_75215_d(toInsert);
        ItemStack remainingStack = stack.func_77946_l();
        remainingStack.func_190920_e(remaining);
        return remainingStack;
    }

    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        WidgetSlot targetSlot;
        int targetSlotId;
        Slot uncastSlot = (Slot)this.field_75151_b.get(index);
        if (uncastSlot == null || !uncastSlot.func_75216_d() || !(uncastSlot instanceof WidgetSlot)) {
            return ItemStack.field_190927_a;
        }
        WidgetSlot slot = (WidgetSlot)uncastSlot;
        ItemStack stackToMove = uncastSlot.func_75211_c().func_77946_l();
        if (stackToMove.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        this.slotGroups.setPointerTo(slot.getGroupId());
        ArrayList<Integer> availableSlotsInOrderOfPriority = this.getTransferTargetSlots(slot.func_75211_c());
        Iterator iterator = availableSlotsInOrderOfPriority.iterator();
        while (iterator.hasNext() && ((targetSlotId = ((Integer)iterator.next()).intValue()) == index || !(stackToMove = this.insertStackIntoSlot(targetSlot = (WidgetSlot)((Object)this.field_75151_b.get(targetSlotId)), stackToMove)).func_190926_b())) {
        }
        slot.func_75215_d(stackToMove);
        return ItemStack.field_190927_a;
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return true;
    }
}

