/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.libnonymous.gui.framework;

import com.davenonymous.libnonymous.gui.framework.GUIHelper;
import com.davenonymous.libnonymous.gui.framework.widgets.IValueProvider;
import com.davenonymous.libnonymous.gui.framework.widgets.Widget;
import com.davenonymous.libnonymous.gui.framework.widgets.WidgetPanel;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.inventory.container.Slot;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.gui.GuiUtils;

public class GUI
extends WidgetPanel {
    public static ResourceLocation tabIcons = new ResourceLocation("libnonymous", "textures/gui/tabicons.png");
    public static ResourceLocation defaultButtonTexture = new ResourceLocation("libnonymous", "textures/gui/button_background.png");
    public boolean hasTabs = false;
    private Map<ResourceLocation, IValueProvider> valueMap = new HashMap<ResourceLocation, IValueProvider>();

    public GUI(int x, int y, int width, int height) {
        this.setX(x);
        this.setY(y);
        this.setWidth(width);
        this.setHeight(height);
    }

    public void findValueWidgets() {
        this.findValueWidgets(this);
    }

    public void registerValueWidget(ResourceLocation id, IValueProvider widget) {
        this.valueMap.put(id, widget);
    }

    public Object getValue(ResourceLocation id) {
        if (id == null || !this.valueMap.containsKey(id)) {
            return null;
        }
        return this.valueMap.get(id).getValue();
    }

    public void drawGUI(Screen screen) {
        this.setX((screen.width - this.width) / 2);
        this.setY((screen.height - this.height) / 2);
        this.shiftAndDraw(screen);
    }

    @Override
    public void drawBeforeShift(Screen screen) {
        super.drawBeforeShift(screen);
    }

    @Override
    public void draw(Screen screen) {
        this.drawWindow(screen);
        super.draw(screen);
    }

    protected void drawWindow(Screen screen) {
        RenderHelper.func_74518_a();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        screen.getMinecraft().field_71446_o.func_110577_a(tabIcons);
        int texOffsetY = 11;
        int texOffsetX = 64;
        int width = this.width;
        int xOffset = 0;
        if (this.hasTabs) {
            width -= 32;
            xOffset += 32;
        }
        GuiUtils.drawTexturedModalRect((int)xOffset, (int)0, (int)texOffsetX, (int)texOffsetY, (int)4, (int)4, (float)0.0f);
        GuiUtils.drawTexturedModalRect((int)(xOffset + width - 4), (int)0, (int)(texOffsetX + 4 + 64), (int)texOffsetY, (int)4, (int)4, (float)0.0f);
        GuiUtils.drawTexturedModalRect((int)xOffset, (int)(this.height - 4), (int)texOffsetX, (int)(texOffsetY + 4 + 64), (int)4, (int)4, (float)0.0f);
        GuiUtils.drawTexturedModalRect((int)(xOffset + width - 4), (int)(this.height - 4), (int)(texOffsetX + 4 + 64), (int)(texOffsetY + 4 + 64), (int)4, (int)4, (float)0.0f);
        GUIHelper.drawStretchedTexture(xOffset + 4, 0, width - 8, 4, texOffsetX + 4, texOffsetY, 64, 4);
        GUIHelper.drawStretchedTexture(xOffset + 4, this.height - 4, width - 8, 4, texOffsetX + 4, texOffsetY + 4 + 64, 64, 4);
        GUIHelper.drawStretchedTexture(xOffset, 4, 4, this.height - 8, texOffsetX, texOffsetY + 4, 4, 64);
        GUIHelper.drawStretchedTexture(xOffset + width - 4, 4, 4, this.height - 8, texOffsetX + 64 + 4, texOffsetY + 3, 4, 64);
        GUIHelper.drawStretchedTexture(xOffset + 4, 4, width - 8, this.height - 8, texOffsetX + 4, texOffsetY + 4, 64, 64);
    }

    public void drawTooltips(Screen screen, int mouseX, int mouseY) {
        Widget hoveredWidget = this.getHoveredWidget(mouseX, mouseY);
        FontRenderer font = screen.getMinecraft().field_71466_p;
        if (hoveredWidget != null && hoveredWidget.getTooltip() != null && hoveredWidget.getTooltip().size() > 0) {
            GuiUtils.drawHoveringText(hoveredWidget.getTooltipAsString(), (int)mouseX, (int)mouseY, (int)this.width, (int)this.height, (int)180, (FontRenderer)font);
        }
    }

    public void drawSlot(Screen screen, Slot slot, int guiLeft, int guiTop) {
        RenderHelper.func_74518_a();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        screen.getMinecraft().field_71446_o.func_110577_a(tabIcons);
        float offsetX = guiLeft - 1;
        float offsetY = guiTop - 1;
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)offsetX, (float)offsetY, (float)0.0f);
        int texOffsetY = 84;
        int texOffsetX = 84;
        GuiUtils.drawTexturedModalRect((int)slot.field_75223_e, (int)slot.field_75221_f, (int)texOffsetX, (int)texOffsetY, (int)18, (int)18, (float)0.0f);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.popMatrix();
    }
}

