/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.libnonymous.gui.config.types;

import com.davenonymous.libnonymous.gui.framework.ColorHelper;
import com.davenonymous.libnonymous.gui.framework.event.MouseClickEvent;
import com.davenonymous.libnonymous.gui.framework.event.WidgetEventResult;
import com.davenonymous.libnonymous.gui.framework.util.FontAwesomeIcons;
import com.davenonymous.libnonymous.gui.framework.widgets.WidgetFontAwesome;
import com.davenonymous.libnonymous.gui.framework.widgets.WidgetListEntry;
import com.davenonymous.libnonymous.gui.framework.widgets.WidgetTextBox;
import com.davenonymous.libnonymous.utils.FontAwesomeHelper;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.ForgeConfigSpec;

public abstract class SettingListEntry
extends WidgetListEntry {
    public static final FontAwesomeIcons SAVE_ICON = FontAwesomeIcons.REGULAR_Save;
    protected int columnWidth;
    protected ForgeConfigSpec.ConfigValue value;
    protected Object defaultValue;
    protected WidgetTextBox label;
    protected WidgetTextBox labelComment;
    protected WidgetFontAwesome errorIcon;
    protected WidgetFontAwesome restoreDefaultIcon;

    public SettingListEntry(String optionKey, String comment, ForgeConfigSpec.ConfigValue value, Object defaultValue, int columnWidth) {
        String trimmedComment;
        this.columnWidth = columnWidth;
        this.value = value;
        this.defaultValue = defaultValue;
        int availableSpaceForText = columnWidth - 30;
        int optionKeyStringWidth = Minecraft.func_71410_x().field_71466_p.func_78256_a(optionKey);
        this.label = new WidgetTextBox(optionKey, -1593835521);
        this.label.setDimensions(2, 2, optionKeyStringWidth + 1, 9);
        this.add(this.label);
        if (comment == null) {
            comment = "";
        }
        if ((trimmedComment = Minecraft.func_71410_x().field_71466_p.func_78269_a(comment, availableSpaceForText - 13)).length() < comment.length()) {
            trimmedComment = trimmedComment + "...";
        }
        int headerHeight = 14;
        int commentHeight = 9;
        if (trimmedComment.length() <= 0) {
            commentHeight = 0;
        }
        this.labelComment = new WidgetTextBox(trimmedComment, -1597190964);
        this.labelComment.setDimensions(2, 13, availableSpaceForText, commentHeight);
        this.add(this.labelComment);
        if (comment.length() > 0) {
            this.label.setTooltipLines(new ITextComponent[]{new StringTextComponent(comment)});
            this.labelComment.setTooltipLines(new ITextComponent[]{new StringTextComponent(comment)});
        }
        this.setSize(columnWidth, 45);
        this.errorIcon = new WidgetFontAwesome(FontAwesomeIcons.SOLID_ExclamationTriangle, WidgetFontAwesome.IconSize.MEDIUM);
        this.errorIcon.setPosition(columnWidth - 18, 2);
        this.errorIcon.setColor(ColorHelper.COLOR_ERRORED);
        this.errorIcon.setVisible(false);
        this.add(this.errorIcon);
        this.restoreDefaultIcon = new WidgetFontAwesome(FontAwesomeIcons.SOLID_UndoAlt, WidgetFontAwesome.IconSize.TINY);
        this.restoreDefaultIcon.setColor(ColorHelper.COLOR_DISABLED);
        this.restoreDefaultIcon.setPosition(optionKeyStringWidth + 5, 2);
        this.restoreDefaultIcon.setTooltipLines(Arrays.asList(new TranslationTextComponent("libnonymous.config.gui.tooltip.default_is", new Object[0]), new StringTextComponent(defaultValue != null ? defaultValue.toString() : "")));
        this.restoreDefaultIcon.addListener(MouseClickEvent.class, (event, widget) -> {
            value.set(defaultValue);
            value.save();
            this.updateDefaultIconState();
            this.setValueInInputField(defaultValue);
            return WidgetEventResult.HANDLED;
        });
        this.updateDefaultIconState();
        this.add(this.restoreDefaultIcon);
        this.fillPanel(headerHeight + 5 + commentHeight);
    }

    protected void updateDefaultIconState() {
        if (this.value.get() == null) {
            return;
        }
        if (this.value.get().equals(this.defaultValue)) {
            this.restoreDefaultIcon.setColor(ColorHelper.COLOR_DISABLED);
        } else {
            this.restoreDefaultIcon.setColor(ColorHelper.COLOR_ENABLED);
        }
    }

    protected void showErrorIcon(String message) {
        this.errorIcon.setTooltipLines(new ITextComponent[]{new StringTextComponent(message)});
        this.errorIcon.setVisible(true);
    }

    protected void hideErrorIcon() {
        this.errorIcon.setVisible(false);
    }

    protected void addUnsupportedRow(int entryHeight) {
        this.setSize(this.columnWidth, entryHeight + 17);
        WidgetTextBox textBox = new WidgetTextBox(I18n.func_135052_a((String)"libnonymous.config.error.unsupported_config_type", (Object[])new Object[0]), ColorHelper.COLOR_ERRORED.getRGB());
        textBox.setSize(this.columnWidth - 10, 9);
        textBox.setPosition(25, 30);
        this.add(textBox);
        WidgetFontAwesome sadIcon = new WidgetFontAwesome(FontAwesomeHelper.getRandomAnimalIcon(), WidgetFontAwesome.IconSize.MEDIUM);
        sadIcon.setColor(ColorHelper.COLOR_ERRORED);
        sadIcon.setPosition(6, 24);
        this.add(sadIcon);
    }

    public abstract void setValueInInputField(Object var1);

    public abstract void fillPanel(int var1);
}

