/*
 * Decompiled with CFR 0.152.
 */
package info.tehnut.soulshardsrespawn.core;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import info.tehnut.soulshardsrespawn.core.data.MultiblockPattern;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.EntityClassification;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class ConfigSoulShards {
    private static MultiblockPattern multiblock;
    private ConfigBalance balance;
    private ConfigClient client;
    private ConfigEntityList entityList;

    private ConfigSoulShards(ConfigBalance balance, ConfigClient client, ConfigEntityList entityList) {
        this.balance = balance;
        this.client = client;
        this.entityList = entityList;
    }

    public ConfigSoulShards() {
        this(new ConfigBalance(), new ConfigClient(), new ConfigEntityList());
    }

    public ConfigBalance getBalance() {
        return this.balance;
    }

    public ConfigClient getClient() {
        return this.client;
    }

    public ConfigEntityList getEntityList() {
        return this.entityList;
    }

    public static void handleMultiblock() {
        if (multiblock == null) {
            multiblock = MultiblockPattern.DEFAULT;
        }
    }

    public static MultiblockPattern getMultiblock() {
        if (multiblock == null) {
            ConfigSoulShards.handleMultiblock();
        }
        return multiblock;
    }

    public static class ConfigEntityList {
        private static final Set<String> DEFAULT_DISABLES = Sets.newHashSet((Object[])new String[]{"minecraft:armor_stand", "minecraft:elder_guardian", "minecraft:ender_dragon", "minecraft:wither", "minecraft:wither", "minecraft:player"});
        private Map<String, Boolean> entities;

        public ConfigEntityList(Map<String, Boolean> entities) {
            this.entities = entities;
        }

        public ConfigEntityList() {
            this(ConfigEntityList.getDefaults());
        }

        public boolean isEnabled(ResourceLocation entityId) {
            return this.entities.getOrDefault(entityId.toString(), false);
        }

        private static Map<String, Boolean> getDefaults() {
            HashMap defaults = Maps.newHashMap();
            ForgeRegistries.ENTITIES.getValues().stream().filter(e -> e.func_220339_d() != EntityClassification.MISC).forEach(e -> {
                String entityId;
                defaults.put(entityId, !DEFAULT_DISABLES.contains(entityId = e.getRegistryName().toString()));
            });
            return defaults;
        }
    }

    public static class ConfigClient {
        private boolean displayDurabilityBar;

        public ConfigClient(boolean displayDurabilityBar) {
            this.displayDurabilityBar = displayDurabilityBar;
        }

        public ConfigClient() {
            this(true);
        }

        public boolean displayDurabilityBar() {
            return this.displayDurabilityBar;
        }
    }

    public static class ConfigBalance {
        private boolean allowSpawnerAbsorption;
        private boolean allowFakePlayers;
        private int absorptionBonus;
        private boolean allowBossSpawns;
        private boolean countCageBornForShard;
        private boolean requireOwnerOnline;
        private boolean requireRedstoneSignal;
        private boolean allowShardCombination;
        private int spawnCap;
        private boolean dropExperience;

        public ConfigBalance(boolean allowSpawnerAbsorption, boolean allowFakePlayers, int absorptionBonus, boolean allowBossSpawns, boolean countCageBornForShard, boolean requireOwnerOnline, boolean requireRedstoneSignal, boolean allowShardCombination, int spawnCap, boolean dropExperience) {
            this.allowSpawnerAbsorption = allowSpawnerAbsorption;
            this.allowFakePlayers = allowFakePlayers;
            this.absorptionBonus = absorptionBonus;
            this.allowBossSpawns = allowBossSpawns;
            this.countCageBornForShard = countCageBornForShard;
            this.requireOwnerOnline = requireOwnerOnline;
            this.requireRedstoneSignal = requireRedstoneSignal;
            this.allowShardCombination = allowShardCombination;
            this.spawnCap = spawnCap;
            this.dropExperience = dropExperience;
        }

        public ConfigBalance() {
            this(true, false, 200, false, false, false, false, true, 32, false);
        }

        public boolean allowSpawnerAbsorption() {
            return this.allowSpawnerAbsorption;
        }

        public boolean allowFakePlayers() {
            return this.allowFakePlayers;
        }

        public int getAbsorptionBonus() {
            return this.absorptionBonus;
        }

        public boolean allowBossSpawns() {
            return this.allowBossSpawns;
        }

        public boolean countCageBornForShard() {
            return this.countCageBornForShard;
        }

        public boolean requireOwnerOnline() {
            return this.requireOwnerOnline;
        }

        public boolean requireRedstoneSignal() {
            return this.requireRedstoneSignal;
        }

        public boolean allowShardCombination() {
            return this.allowShardCombination;
        }

        public int getSpawnCap() {
            return this.spawnCap;
        }

        public boolean shouldDropExperience() {
            return this.dropExperience;
        }
    }
}

