/*
 * Decompiled with CFR 0.152.
 */
package mods.waterstrainer;

import java.io.File;
import mods.waterstrainer.Config;
import mods.waterstrainer.event.EventPlayerLoggedIn;
import mods.waterstrainer.event.EventServerStarting;
import mods.waterstrainer.gui.GuiStrainer;
import mods.waterstrainer.gui.GuiWormBin;
import mods.waterstrainer.inventory.ContainerStrainer;
import mods.waterstrainer.inventory.ContainerWormBin;
import mods.waterstrainer.network.PacketHandler;
import mods.waterstrainer.registry.BlockRegistry;
import mods.waterstrainer.registry.FileRegistry;
import mods.waterstrainer.registry.ItemRegistry;
import mods.waterstrainer.tileentity.TileEntityStrainer;
import mods.waterstrainer.tileentity.TileEntityWormBin;
import net.minecraft.block.Block;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.extensions.IForgeContainerType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="waterstrainer")
public class WaterStrainer {
    public static final String MODID = "waterstrainer";
    public static final String MODNAME = "Water Strainer";
    public static final String MODNAME_NOSPACE = "WaterStrainer";
    public static final String VERSION = "1.15.2-9.0.0";
    public static TileEntityType<TileEntityStrainer> tile_strainer_base;
    public static TileEntityType<TileEntityWormBin> tile_worm_bin;
    public static ContainerType<ContainerStrainer> container_strainer_base;
    public static ContainerType<ContainerWormBin> container_worm_bin;
    public static final ItemGroup tabWaterStrainer;
    public static final Logger LOGGER;

    public WaterStrainer() {
        new File("config/waterstrainer").mkdirs();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, Config.CONFIG_SPEC, "waterstrainer/waterstrainer.toml");
        PacketHandler.register();
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::commonSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::modConfig);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new EventServerStarting());
        MinecraftForge.EVENT_BUS.register((Object)new EventPlayerLoggedIn());
    }

    public void modConfig(ModConfig.ModConfigEvent event) {
        if (event.getConfig().getSpec() == Config.CONFIG_SPEC) {
            Config.refreshConfigValues();
        }
    }

    private void commonSetup(FMLCommonSetupEvent e) {
        FileRegistry.LOOTTABLE.init();
    }

    private void clientSetup(FMLClientSetupEvent e) {
        ScreenManager.func_216911_a(container_strainer_base, GuiStrainer::new);
        ScreenManager.func_216911_a(container_worm_bin, GuiWormBin::new);
        RenderTypeLookup.setRenderLayer((Block)BlockRegistry.strainer_base, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)BlockRegistry.worm_bin, (RenderType)RenderType.func_228643_e_());
    }

    static {
        tabWaterStrainer = new ItemGroup("waterstrainer.main"){

            public ItemStack func_78016_d() {
                return new ItemStack((IItemProvider)ItemRegistry.strainer_survivalist);
            }
        };
        LOGGER = LogManager.getLogger();
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void registerTileEntities(RegistryEvent.Register<TileEntityType<?>> event) {
            tile_strainer_base = (TileEntityType)TileEntityType.Builder.func_223042_a(TileEntityStrainer::new, (Block[])new Block[]{BlockRegistry.strainer_base}).func_206865_a(null).setRegistryName("strainer");
            event.getRegistry().register((IForgeRegistryEntry)tile_strainer_base);
            tile_worm_bin = (TileEntityType)TileEntityType.Builder.func_223042_a(TileEntityWormBin::new, (Block[])new Block[]{BlockRegistry.worm_bin}).func_206865_a(null).setRegistryName("worm_bin");
            event.getRegistry().register((IForgeRegistryEntry)tile_worm_bin);
        }

        @SubscribeEvent
        public static void registerContainer(RegistryEvent.Register<ContainerType<?>> event) {
            container_strainer_base = (ContainerType)IForgeContainerType.create(ContainerStrainer::new).setRegistryName("container_strainer");
            event.getRegistry().register((IForgeRegistryEntry)container_strainer_base);
            container_worm_bin = (ContainerType)IForgeContainerType.create(ContainerWormBin::new).setRegistryName("container_worm_bin");
            event.getRegistry().register((IForgeRegistryEntry)container_worm_bin);
        }
    }
}

