/*
 * Decompiled with CFR 0.152.
 */
package com.endlesnights.torchslabsmod.blocks.upgradeaquatic;

import com.endlesnights.torchslabsmod.blocks.vanilla.BlockWallTorchSlab;
import com.teamabnormals.upgrade_aquatic.client.particle.UAParticles;
import com.teamabnormals.upgrade_aquatic.core.registry.UABlocks;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IBucketPickupHandler;
import net.minecraft.block.ILiquidContainer;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.Half;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlockWallJellyTorchSlab
extends BlockWallTorchSlab
implements IBucketPickupHandler,
ILiquidContainer,
IWaterLoggable {
    private final JellyTorchType torchType;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;

    public BlockWallJellyTorchSlab(Block.Properties props, JellyTorchType torchType) {
        super(props);
        this.torchType = torchType;
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)field_196532_a, (Comparable)Direction.NORTH)).func_206870_a((IProperty)HALF, (Comparable)Half.BOTTOM));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState state, World world, BlockPos pos, Random random) {
        Direction direction = (Direction)state.func_177229_b((IProperty)field_196532_a);
        double xOffset = random.nextBoolean() ? -(Math.random() * 0.075) : Math.random() * 0.075;
        double yOffset = random.nextBoolean() ? -(Math.random() * 0.075) : Math.random() * 0.075;
        double zOffset = random.nextBoolean() ? -(Math.random() * 0.075) : Math.random() * 0.075;
        double d0 = (double)pos.func_177958_n() + 0.5 + xOffset;
        double d1 = (double)pos.func_177956_o() + 0.45 + yOffset;
        double d2 = (double)pos.func_177952_p() + 0.5 + zOffset;
        double d3 = 0.18;
        double d4 = 0.3;
        if (state.func_177229_b((IProperty)HALF) == Half.TOP) {
            d1 += 0.5;
        }
        Direction facing = direction.func_176734_d();
        world.func_195594_a((IParticleData)BlockWallJellyTorchSlab.getTorchParticleType(this.torchType), d0 + d4 * (double)facing.func_82601_c(), d1 + d3, d2 + d4 * (double)facing.func_82599_e(), 0.0, 0.004, 0.0);
    }

    @Override
    public void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{WATERLOGGED, field_196532_a, HALF});
    }

    @Override
    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((IProperty)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return super.func_196271_a(stateIn, facing, stateIn, worldIn, currentPos, facingPos);
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        IFluidState ifluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        return (BlockState)super.func_196258_a(context).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.func_206886_c() == Fluids.field_204546_a));
    }

    public Fluid func_204508_a(IWorld worldIn, BlockPos pos, BlockState state) {
        if (((Boolean)state.func_177229_b((IProperty)WATERLOGGED)).booleanValue()) {
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false)), 3);
            return Fluids.field_204546_a;
        }
        return Fluids.field_204541_a;
    }

    public IFluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public boolean func_204510_a(IBlockReader worldIn, BlockPos pos, BlockState state, Fluid fluidIn) {
        return (Boolean)state.func_177229_b((IProperty)WATERLOGGED) == false && fluidIn == Fluids.field_204546_a;
    }

    public boolean func_204509_a(IWorld worldIn, BlockPos pos, BlockState state, IFluidState fluidStateIn) {
        if (!((Boolean)state.func_177229_b((IProperty)WATERLOGGED)).booleanValue() && fluidStateIn.func_206886_c() == Fluids.field_204546_a) {
            if (!worldIn.func_201670_d()) {
                worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(true)), 3);
                worldIn.func_205219_F_().func_205360_a(pos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
            }
            return true;
        }
        return false;
    }

    public static BasicParticleType getTorchParticleType(JellyTorchType type) {
        switch (type) {
            default: {
                return UAParticles.PINK_JELLY_FLAME;
            }
            case PURPLE: {
                return UAParticles.PURPLE_JELLY_FLAME;
            }
            case BLUE: {
                return UAParticles.BLUE_JELLY_FLAME;
            }
            case GREEN: {
                return UAParticles.GREEN_JELLY_FLAME;
            }
            case YELLOW: {
                return UAParticles.YELLOW_JELLY_FLAME;
            }
            case ORANGE: {
                return UAParticles.ORANGE_JELLY_FLAME;
            }
            case RED: {
                return UAParticles.RED_JELLY_FLAME;
            }
            case WHITE: 
        }
        return UAParticles.WHITE_JELLY_FLAME;
    }

    public ResourceLocation func_220068_i() {
        switch (this.torchType) {
            default: {
                return ((Block)UABlocks.JELLY_TORCH_PINK.get()).func_220068_i();
            }
            case PURPLE: {
                return ((Block)UABlocks.JELLY_TORCH_PURPLE.get()).func_220068_i();
            }
            case BLUE: {
                return ((Block)UABlocks.JELLY_TORCH_BLUE.get()).func_220068_i();
            }
            case GREEN: {
                return ((Block)UABlocks.JELLY_TORCH_GREEN.get()).func_220068_i();
            }
            case YELLOW: {
                return ((Block)UABlocks.JELLY_TORCH_YELLOW.get()).func_220068_i();
            }
            case ORANGE: {
                return ((Block)UABlocks.JELLY_TORCH_ORANGE.get()).func_220068_i();
            }
            case RED: {
                return ((Block)UABlocks.JELLY_TORCH_RED.get()).func_220068_i();
            }
            case WHITE: 
        }
        return ((Block)UABlocks.JELLY_TORCH_WHITE.get()).func_220068_i();
    }

    @Override
    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        switch (this.torchType) {
            default: {
                return new ItemStack((IItemProvider)UABlocks.JELLY_TORCH_PINK.get());
            }
            case PURPLE: {
                return new ItemStack((IItemProvider)UABlocks.JELLY_TORCH_PURPLE.get());
            }
            case BLUE: {
                return new ItemStack((IItemProvider)UABlocks.JELLY_TORCH_BLUE.get());
            }
            case GREEN: {
                return new ItemStack((IItemProvider)UABlocks.JELLY_TORCH_GREEN.get());
            }
            case YELLOW: {
                return new ItemStack((IItemProvider)UABlocks.JELLY_TORCH_YELLOW.get());
            }
            case ORANGE: {
                return new ItemStack((IItemProvider)UABlocks.JELLY_TORCH_ORANGE.get());
            }
            case RED: {
                return new ItemStack((IItemProvider)UABlocks.JELLY_TORCH_RED.get());
            }
            case WHITE: 
        }
        return new ItemStack((IItemProvider)UABlocks.JELLY_TORCH_WHITE.get());
    }

    public static enum JellyTorchType {
        PINK(TextFormatting.LIGHT_PURPLE),
        PURPLE(TextFormatting.DARK_PURPLE),
        BLUE(TextFormatting.BLUE),
        GREEN(TextFormatting.GREEN),
        YELLOW(TextFormatting.YELLOW),
        ORANGE(TextFormatting.GOLD),
        RED(TextFormatting.RED),
        WHITE(TextFormatting.WHITE);

        public final TextFormatting color;

        private JellyTorchType(TextFormatting color) {
            this.color = color;
        }
    }
}

