/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.rendering;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import javax.annotation.Nullable;
import mcjty.theoneprobe.TheOneProbe;
import mcjty.theoneprobe.network.ThrowableIdentity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.HangingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;

public class RenderHelper {
    public static float rot = 0.0f;

    public static void renderEntity(Entity entity, int xPos, int yPos, float scale) {
        RenderSystem.pushMatrix();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableRescaleNormal();
        RenderSystem.enableColorMaterial();
        RenderSystem.translatef((float)(xPos + 8), (float)(yPos + 24), (float)50.0f);
        RenderSystem.scalef((float)(-scale), (float)scale, (float)scale);
        RenderSystem.rotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        RenderSystem.rotatef((float)135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        net.minecraft.client.renderer.RenderHelper.func_227780_a_();
        RenderSystem.rotatef((float)-135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        RenderSystem.rotatef((float)rot, (float)0.0f, (float)1.0f, (float)0.0f);
        RenderSystem.rotatef((float)0.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        entity.field_70125_A = 0.0f;
        entity.field_70127_C = 0.0f;
        entity.field_70177_z = 0.0f;
        entity.field_70126_B = 0.0f;
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            livingEntity.field_70760_ar = 0.0f;
            livingEntity.field_70761_aq = 0.0f;
            livingEntity.field_70759_as = 0.0f;
            livingEntity.field_70758_at = 0.0f;
        }
        RenderSystem.translatef((float)0.0f, (float)((float)entity.func_70033_W() + (entity instanceof HangingEntity ? 0.5f : 0.0f)), (float)0.0f);
        try {
            IRenderTypeBuffer.Impl buffer = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
            Minecraft.func_71410_x().func_175598_ae().func_229084_a_(entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, new MatrixStack(), (IRenderTypeBuffer)buffer, 0xF000F0);
            buffer.func_228461_a_();
        }
        catch (Exception e) {
            TheOneProbe.logger.error("Error rendering entity!", (Throwable)e);
        }
        net.minecraft.client.renderer.RenderHelper.func_74518_a();
        RenderSystem.disableRescaleNormal();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableLighting();
        RenderSystem.enableDepthTest();
        RenderSystem.disableColorMaterial();
        Minecraft.func_71410_x().field_71460_t.func_228384_l_().func_205108_b();
        RenderSystem.popMatrix();
    }

    public static void drawHorizontalLine(int x1, int y1, int x2, int color) {
        AbstractGui.fill((int)x1, (int)y1, (int)x2, (int)(y1 + 1), (int)color);
    }

    public static void drawVerticalLine(int x1, int y1, int y2, int color) {
        AbstractGui.fill((int)x1, (int)y1, (int)(x1 + 1), (int)y2, (int)color);
    }

    public static void drawThickBeveledBox(int x1, int y1, int x2, int y2, int thickness, int topleftcolor, int botrightcolor, int fillcolor) {
        if (fillcolor != -1) {
            AbstractGui.fill((int)(x1 + 1), (int)(y1 + 1), (int)(x2 - 1), (int)(y2 - 1), (int)fillcolor);
        }
        AbstractGui.fill((int)x1, (int)y1, (int)(x2 - 1), (int)(y1 + thickness), (int)topleftcolor);
        AbstractGui.fill((int)x1, (int)y1, (int)(x1 + thickness), (int)(y2 - 1), (int)topleftcolor);
        AbstractGui.fill((int)(x2 - thickness), (int)y1, (int)x2, (int)(y2 - 1), (int)botrightcolor);
        AbstractGui.fill((int)x1, (int)(y2 - thickness), (int)x2, (int)y2, (int)botrightcolor);
    }

    public static void drawTexturedModalRect(int x, int y, int u, int v, int width, int height, int twidth, int theight) {
        float zLevel = 0.01f;
        float f = 1.0f / (float)twidth;
        float f1 = 1.0f / (float)theight;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_225582_a_((double)(x + 0), (double)(y + height), (double)zLevel).func_225583_a_((float)(u + 0) * f, (float)(v + height) * f1).func_181675_d();
        buffer.func_225582_a_((double)(x + width), (double)(y + height), (double)zLevel).func_225583_a_((float)(u + width) * f, (float)(v + height) * f1).func_181675_d();
        buffer.func_225582_a_((double)(x + width), (double)(y + 0), (double)zLevel).func_225583_a_((float)(u + width) * f, (float)(v + 0) * f1).func_181675_d();
        buffer.func_225582_a_((double)(x + 0), (double)(y + 0), (double)zLevel).func_225583_a_((float)(u + 0) * f, (float)(v + 0) * f1).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void drawTexturedModalRect(int x, int y, int u, int v, int width, int height) {
        float zLevel = 0.01f;
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_225582_a_((double)(x + 0), (double)(y + height), (double)zLevel).func_225583_a_((float)(u + 0) * f, (float)(v + height) * f1).func_181675_d();
        buffer.func_225582_a_((double)(x + width), (double)(y + height), (double)zLevel).func_225583_a_((float)(u + width) * f, (float)(v + height) * f1).func_181675_d();
        buffer.func_225582_a_((double)(x + width), (double)(y + 0), (double)zLevel).func_225583_a_((float)(u + width) * f, (float)(v + 0) * f1).func_181675_d();
        buffer.func_225582_a_((double)(x + 0), (double)(y + 0), (double)zLevel).func_225583_a_((float)(u + 0) * f, (float)(v + 0) * f1).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void drawTexturedModalRect(int x, int y, TextureAtlasSprite sprite, int width, int height) {
        float zLevel = 0.01f;
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        float u1 = sprite.func_94209_e();
        float v1 = sprite.func_94206_g();
        float u2 = sprite.func_94212_f();
        float v2 = sprite.func_94210_h();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_225582_a_((double)(x + 0), (double)(y + height), (double)zLevel).func_225583_a_(u1, v1).func_181675_d();
        buffer.func_225582_a_((double)(x + width), (double)(y + height), (double)zLevel).func_225583_a_(u1, v2).func_181675_d();
        buffer.func_225582_a_((double)(x + width), (double)(y + 0), (double)zLevel).func_225583_a_(u2, v2).func_181675_d();
        buffer.func_225582_a_((double)(x + 0), (double)(y + 0), (double)zLevel).func_225583_a_(u2, v1).func_181675_d();
        tessellator.func_78381_a();
    }

    public static boolean renderItemStack(Minecraft mc, ItemRenderer itemRender, ItemStack itm, int x, int y, String txt) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        boolean rc = true;
        if (!itm.func_190926_b() && itm.func_77973_b() != null) {
            RenderSystem.pushMatrix();
            RenderSystem.translatef((float)0.0f, (float)0.0f, (float)32.0f);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.enableRescaleNormal();
            RenderSystem.enableLighting();
            int short1 = 240;
            int short2 = 240;
            net.minecraft.client.renderer.RenderHelper.func_227784_d_();
            try {
                itemRender.func_180450_b(itm, x, y);
                RenderHelper.renderItemStackOverlay(mc.field_71466_p, itm, x, y, txt, txt.length() - 2);
            }
            catch (Exception e) {
                ThrowableIdentity.registerThrowable(e);
                rc = false;
            }
            RenderSystem.popMatrix();
            RenderSystem.disableRescaleNormal();
            RenderSystem.disableLighting();
        }
        return rc;
    }

    public static void renderItemStackOverlay(FontRenderer fr, ItemStack stack, int xPosition, int yPosition, @Nullable String text, int scaled) {
        if (!stack.func_190926_b()) {
            ClientPlayerEntity PlayerEntitysp;
            float f;
            if (stack.func_190916_E() != 1 || text != null) {
                String s;
                String string = s = text == null ? String.valueOf(stack.func_190916_E()) : text;
                if (text == null && stack.func_190916_E() < 1) {
                    s = TextFormatting.RED + String.valueOf(stack.func_190916_E());
                }
                RenderSystem.translated((double)0.0, (double)0.0, (double)(Minecraft.func_71410_x().func_175599_af().field_77023_b + 200.0f));
                RenderSystem.disableLighting();
                RenderSystem.disableDepthTest();
                RenderSystem.disableBlend();
                if (scaled >= 2) {
                    RenderSystem.pushMatrix();
                    RenderSystem.scalef((float)0.5f, (float)0.5f, (float)0.5f);
                    fr.func_175063_a(s, (float)((xPosition + 19 - 2) * 2 - 1 - fr.func_78256_a(s)), (float)(yPosition * 2 + 24), 0xFFFFFF);
                    RenderSystem.popMatrix();
                } else if (scaled == 1) {
                    RenderSystem.pushMatrix();
                    RenderSystem.scalef((float)0.75f, (float)0.75f, (float)0.75f);
                    fr.func_175063_a(s, (float)(xPosition - 2) * 1.34f + 24.0f - (float)fr.func_78256_a(s), (float)yPosition * 1.34f + 14.0f, 0xFFFFFF);
                    RenderSystem.popMatrix();
                } else {
                    fr.func_175063_a(s, (float)(xPosition + 19 - 2 - fr.func_78256_a(s)), (float)(yPosition + 6 + 3), 0xFFFFFF);
                }
                RenderSystem.enableLighting();
                RenderSystem.enableDepthTest();
                RenderSystem.enableBlend();
            }
            if (stack.func_77973_b().showDurabilityBar(stack)) {
                double health = stack.func_77973_b().getDurabilityForDisplay(stack);
                int j = (int)Math.round(13.0 - health * 13.0);
                int i = (int)Math.round(255.0 - health * 255.0);
                RenderSystem.disableLighting();
                RenderSystem.disableDepthTest();
                RenderSystem.disableTexture();
                RenderSystem.disableAlphaTest();
                RenderSystem.disableBlend();
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder vertexbuffer = tessellator.func_178180_c();
                RenderHelper.draw(vertexbuffer, xPosition + 2, yPosition + 13, 13, 2, 0, 0, 0, 255);
                RenderHelper.draw(vertexbuffer, xPosition + 2, yPosition + 13, 12, 1, (255 - i) / 4, 64, 0, 255);
                RenderHelper.draw(vertexbuffer, xPosition + 2, yPosition + 13, j, 1, 255 - i, i, 0, 255);
                RenderSystem.enableBlend();
                RenderSystem.enableAlphaTest();
                RenderSystem.enableTexture();
                RenderSystem.enableLighting();
                RenderSystem.enableDepthTest();
            }
            float f2 = f = (PlayerEntitysp = Minecraft.func_71410_x().field_71439_g) == null ? 0.0f : PlayerEntitysp.func_184811_cZ().func_185143_a(stack.func_77973_b(), Minecraft.func_71410_x().func_184121_ak());
            if (f > 0.0f) {
                RenderSystem.disableLighting();
                RenderSystem.disableDepthTest();
                RenderSystem.disableTexture();
                Tessellator tessellator1 = Tessellator.func_178181_a();
                BufferBuilder vertexbuffer1 = tessellator1.func_178180_c();
                RenderHelper.draw(vertexbuffer1, xPosition, yPosition + (int)Math.floor(16.0f * (1.0f - f)), 16, (int)Math.ceil(16.0f * f), 255, 255, 255, 127);
                RenderSystem.enableTexture();
                RenderSystem.enableLighting();
                RenderSystem.enableDepthTest();
            }
        }
    }

    private static void draw(BufferBuilder renderer, int x, int y, int width, int height, int red, int green, int blue, int alpha) {
        renderer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        renderer.func_225582_a_((double)(x + 0), (double)(y + 0), 0.0).func_225586_a_(red, green, blue, alpha).func_181675_d();
        renderer.func_225582_a_((double)(x + 0), (double)(y + height), 0.0).func_225586_a_(red, green, blue, alpha).func_181675_d();
        renderer.func_225582_a_((double)(x + width), (double)(y + height), 0.0).func_225586_a_(red, green, blue, alpha).func_181675_d();
        renderer.func_225582_a_((double)(x + width), (double)(y + 0), 0.0).func_225586_a_(red, green, blue, alpha).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
    }

    public static int renderText(Minecraft mc, int x, int y, String txt) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)0.0f, (float)0.0f, (float)32.0f);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableRescaleNormal();
        RenderSystem.enableLighting();
        net.minecraft.client.renderer.RenderHelper.func_227784_d_();
        RenderSystem.disableLighting();
        RenderSystem.disableDepthTest();
        RenderSystem.disableBlend();
        int width = mc.field_71466_p.func_78256_a(txt);
        mc.field_71466_p.func_175063_a(txt, (float)x, (float)y, 0xFFFFFF);
        RenderSystem.enableLighting();
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.popMatrix();
        RenderSystem.disableRescaleNormal();
        RenderSystem.disableLighting();
        return width;
    }

    private static Vector Cross(Vector a, Vector b) {
        float x = a.y * b.z - a.z * b.y;
        float y = a.z * b.x - a.x * b.z;
        float z = a.x * b.y - a.y * b.x;
        return new Vector(x, y, z);
    }

    private static Vector Sub(Vector a, Vector b) {
        return new Vector(a.x - b.x, a.y - b.y, a.z - b.z);
    }

    private static Vector Add(Vector a, Vector b) {
        return new Vector(a.x + b.x, a.y + b.y, a.z + b.z);
    }

    private static Vector Mul(Vector a, float f) {
        return new Vector(a.x * f, a.y * f, a.z * f);
    }

    public static class Vector {
        public final float x;
        public final float y;
        public final float z;

        public Vector(float x, float y, float z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public float getX() {
            return this.x;
        }

        public float getY() {
            return this.y;
        }

        public float getZ() {
            return this.z;
        }

        public float norm() {
            return (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        }

        public Vector normalize() {
            float n = this.norm();
            return new Vector(this.x / n, this.y / n, this.z / n);
        }
    }
}

