/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.network;

import java.util.function.Supplier;
import mcjty.theoneprobe.apiimpl.ProbeInfo;
import mcjty.theoneprobe.rendering.OverlayRenderer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketReturnInfo {
    private DimensionType dim;
    private BlockPos pos;
    private ProbeInfo probeInfo;

    public PacketReturnInfo(PacketBuffer buf) {
        this.dim = DimensionType.func_193417_a((ResourceLocation)buf.func_192575_l());
        this.pos = buf.func_179259_c();
        if (buf.readBoolean()) {
            this.probeInfo = new ProbeInfo();
            this.probeInfo.fromBytes(buf);
        } else {
            this.probeInfo = null;
        }
    }

    public void toBytes(PacketBuffer buf) {
        buf.func_192572_a(this.dim.getRegistryName());
        buf.func_179255_a(this.pos);
        if (this.probeInfo != null) {
            buf.writeBoolean(true);
            this.probeInfo.toBytes(buf);
        } else {
            buf.writeBoolean(false);
        }
    }

    public PacketReturnInfo() {
    }

    public PacketReturnInfo(DimensionType dim, BlockPos pos, ProbeInfo probeInfo) {
        this.dim = dim;
        this.pos = pos;
        this.probeInfo = probeInfo;
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> OverlayRenderer.registerProbeInfo(this.dim, this.pos, this.probeInfo));
        ctx.get().setPacketHandled(true);
    }
}

