/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.config;

import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.file.FileWatcher;
import java.nio.file.Path;
import java.util.function.Function;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.config.ConfigFileTypeHandler;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TombstoneModConfig
extends ModConfig {
    private static final ConfigFileTypeHandler CONFIG_FILE_TYPE_HANDLER = new ConfigFileTypeHandler(){
        private final Logger LOGGER = LogManager.getLogger();

        public Function<ModConfig, CommentedFileConfig> reader(Path configBasePath) {
            return super.reader(FMLPaths.CONFIGDIR.get());
        }

        public void unload(Path configBasePath, ModConfig config) {
            Path configPath = FMLPaths.CONFIGDIR.get().resolve(config.getFileName());
            try {
                FileWatcher.defaultInstance().removeWatch(configPath);
            }
            catch (RuntimeException e) {
                this.LOGGER.error("Failed to remove config {} from tracker!", (Object)configPath.toString(), (Object)e);
            }
        }
    };

    public TombstoneModConfig(ForgeConfigSpec spec, ModContainer container) {
        super(ModConfig.Type.SERVER, spec, container, String.format("%s-%s.toml", container.getModId(), ModConfig.Type.SERVER.extension()));
    }

    public ConfigFileTypeHandler getHandler() {
        return CONFIG_FILE_TYPE_HANDLER;
    }
}

