/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsstorage.modules.scanner;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import mcjty.rftoolsbase.api.screens.IScreenModuleRegistry;
import mcjty.rftoolsbase.api.screens.data.IModuleDataFactory;
import mcjty.rftoolsstorage.modules.scanner.items.StorageControlScreenModule;

public class ScannerModuleRegistry
implements IScreenModuleRegistry {
    private Map<String, IModuleDataFactory<?>> dataFactoryMap = new HashMap();
    private Map<String, Integer> idToIntMap = null;
    private Map<Integer, String> inttoIdMap = null;

    public void registerBuiltins() {
        this.dataFactoryMap.put("rftoolsstorage:storage", StorageControlScreenModule.ModuleDataStacks::new);
    }

    public void registerModuleDataFactory(String id, IModuleDataFactory<?> dataFactory) {
        this.dataFactoryMap.put(id, dataFactory);
    }

    public IModuleDataFactory<?> getModuleDataFactory(String id) {
        return this.dataFactoryMap.get(id);
    }

    public String getNormalId(int i) {
        this.createIdMap();
        return this.inttoIdMap.get(i);
    }

    public int getShortId(String id) {
        this.createIdMap();
        return this.idToIntMap.get(id);
    }

    private void createIdMap() {
        if (this.idToIntMap == null) {
            this.idToIntMap = new HashMap<String, Integer>();
            this.inttoIdMap = new HashMap<Integer, String>();
            ArrayList<String> strings = new ArrayList<String>(this.dataFactoryMap.keySet());
            strings.sort(Comparator.naturalOrder());
            int idx = 0;
            for (String s : strings) {
                this.idToIntMap.put(s, idx);
                this.inttoIdMap.put(idx, s);
                ++idx;
            }
        }
    }
}

