/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.tile.reactor;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Set;
import mekanism.api.Coord4D;
import mekanism.api.providers.IBlockProvider;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.generators.common.FusionReactor;
import mekanism.generators.common.registries.GeneratorsBlocks;
import mekanism.generators.common.tile.reactor.TileEntityReactorController;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public abstract class TileEntityReactorBlock
extends TileEntityMekanism {
    private FusionReactor fusionReactor;
    private boolean attempted;
    public boolean changed;

    public TileEntityReactorBlock() {
        this((IBlockProvider)GeneratorsBlocks.REACTOR_FRAME);
    }

    public TileEntityReactorBlock(IBlockProvider blockProvider) {
        super(blockProvider);
    }

    public abstract boolean isFrame();

    public FusionReactor getReactor() {
        return this.fusionReactor;
    }

    public void setReactor(FusionReactor reactor) {
        if (reactor != this.fusionReactor) {
            this.changed = true;
        }
        this.fusionReactor = reactor;
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.formMultiblock(false);
    }

    protected void onUpdateClient() {
        super.onUpdateClient();
        this.resetChanged();
    }

    protected void resetChanged() {
        if (this.changed) {
            this.changed = false;
        }
    }

    protected void onUpdateServer() {
        super.onUpdateServer();
        this.resetChanged();
        if (!(this.ticker != 5 || this.attempted || this.getReactor() != null && this.getReactor().isFormed())) {
            this.updateController(false);
        }
        this.attempted = false;
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        this.formMultiblock(true);
    }

    public void onAdded() {
        super.onAdded();
        if (!this.isRemote()) {
            if (this.getReactor() == null) {
                this.updateController(true);
            } else {
                this.formMultiblock(false);
            }
        }
    }

    protected void formMultiblock(boolean keepBurning) {
        if (this.getReactor() != null) {
            this.getReactor().formMultiblock(keepBurning);
        }
    }

    private void updateController(boolean fromAdding) {
        if (this instanceof TileEntityReactorController) {
            TileEntityReactorController controller;
            if (!fromAdding && !(controller = (TileEntityReactorController)this).isFormed()) {
                this.formMultiblock(false);
            }
        } else {
            TileEntityReactorController found = new ControllerFinder().find();
            if (found != null && !found.isFormed()) {
                found.formMultiblock(false);
            }
        }
    }

    public class ControllerFinder {
        public TileEntityReactorController found;
        public Set<Coord4D> iterated = new ObjectOpenHashSet();

        public void loop(Coord4D pos) {
            if (this.iterated.size() > 512 || this.found != null) {
                return;
            }
            World world = TileEntityReactorBlock.this.func_145831_w();
            if (world == null) {
                return;
            }
            this.iterated.add(pos);
            for (Direction side : EnumUtils.DIRECTIONS) {
                TileEntityReactorBlock tile;
                Coord4D coord = pos.offset(side);
                BlockPos coordPos = coord.getPos();
                if (this.iterated.contains(coord) || (tile = (TileEntityReactorBlock)MekanismUtils.getTileEntity(TileEntityReactorBlock.class, (IBlockReader)world, (BlockPos)coordPos)) == null) continue;
                tile.attempted = true;
                if (tile instanceof TileEntityReactorController) {
                    this.found = (TileEntityReactorController)tile;
                    return;
                }
                this.loop(coord);
            }
        }

        public TileEntityReactorController find() {
            this.loop(Coord4D.get((TileEntity)TileEntityReactorBlock.this));
            return this.found;
        }
    }
}

