/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.client.gui.element.button;

import javax.annotation.Nonnull;
import mekanism.api.text.EnumColor;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.button.MekanismButton;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.text.TextComponentUtil;
import mekanism.generators.common.MekanismGenerators;
import mekanism.generators.common.tile.reactor.TileEntityReactorLogicAdapter;
import net.minecraft.util.ResourceLocation;

public class ReactorLogicButton
extends MekanismButton {
    private static final ResourceLocation TEXTURE = MekanismGenerators.rl(MekanismUtils.ResourceType.GUI_BUTTON.getPrefix() + "reactor_logic.png");
    @Nonnull
    private final TileEntityReactorLogicAdapter tile;
    private final TileEntityReactorLogicAdapter.ReactorLogic type;

    public ReactorLogicButton(IGuiWrapper gui, int x, int y, TileEntityReactorLogicAdapter.ReactorLogic type, @Nonnull TileEntityReactorLogicAdapter tile, Runnable onPress) {
        super(gui, x, y, 128, 22, "", onPress, (onHover, xAxis, yAxis) -> gui.displayTooltip(type.getDescription(), xAxis, yAxis));
        this.tile = tile;
        this.type = type;
    }

    public void renderButton(int mouseX, int mouseY, float partialTicks) {
        MekanismRenderer.bindTexture((ResourceLocation)TEXTURE);
        MekanismRenderer.color((EnumColor)EnumColor.RED);
        ReactorLogicButton.blit((int)this.x, (int)this.y, (float)0.0f, (float)(this.type == this.tile.logicType ? 22.0f : 0.0f), (int)this.width, (int)this.height, (int)128, (int)44);
        MekanismRenderer.resetColor();
    }

    public TileEntityReactorLogicAdapter.ReactorLogic getType() {
        return this.type;
    }

    public void renderForeground(int mouseX, int mouseY, int xAxis, int yAxis) {
        int typeOffset = 22 * this.type.ordinal();
        this.guiObj.renderItem(this.type.getRenderStack(), 27, 35 + typeOffset);
        this.drawString(TextComponentUtil.build((Object[])new Object[]{EnumColor.WHITE, this.type}), 46, 34 + typeOffset, 0x404040);
        super.renderForeground(mouseX, mouseY, xAxis, yAxis);
    }
}

