/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.client.gui;

import java.util.Arrays;
import java.util.Collections;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.math.FloatingLong;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiEnergyInfo;
import mekanism.client.gui.element.gauge.GaugeType;
import mekanism.client.gui.element.gauge.GuiEnergyGauge;
import mekanism.client.gui.element.gauge.GuiFluidGauge;
import mekanism.client.gui.element.gauge.GuiGasGauge;
import mekanism.client.gui.element.gauge.GuiNumberGauge;
import mekanism.client.gui.element.progress.GuiProgress;
import mekanism.client.gui.element.progress.ProgressType;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.MekanismLang;
import mekanism.common.inventory.container.tile.EmptyTileContainer;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.UnitDisplayUtils;
import mekanism.common.util.text.EnergyDisplay;
import mekanism.generators.client.gui.GuiReactorInfo;
import mekanism.generators.client.gui.element.GuiReactorTab;
import mekanism.generators.common.GeneratorsLang;
import mekanism.generators.common.tile.reactor.TileEntityReactorController;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.util.text.ITextComponent;

public class GuiReactorHeat
extends GuiReactorInfo {
    private static final double MAX_LEVEL = 5.0E8;

    public GuiReactorHeat(EmptyTileContainer<TileEntityReactorController> container, PlayerInventory inv, ITextComponent title) {
        super(container, inv, title);
    }

    @Override
    public void init() {
        super.init();
        this.addButton((Widget)new GuiEnergyInfo(() -> ((TileEntityReactorController)this.tile).isFormed() ? Arrays.asList(MekanismLang.STORING.translate(new Object[]{EnergyDisplay.of((FloatingLong)((TileEntityReactorController)this.tile).energyContainer.getEnergy(), (FloatingLong)((TileEntityReactorController)this.tile).energyContainer.getMaxEnergy())}), GeneratorsLang.PRODUCING_AMOUNT.translate(new Object[]{EnergyDisplay.of((FloatingLong)((TileEntityReactorController)this.tile).getReactor().getPassiveGeneration(false, true))})) : Collections.emptyList(), (IGuiWrapper)this));
        this.addButton((Widget)new GuiNumberGauge(new GuiNumberGauge.INumberInfoHandler(){

            public TextureAtlasSprite getIcon() {
                return MekanismRenderer.getBaseFluidTexture((Fluid)Fluids.field_204547_b, (MekanismRenderer.FluidType)MekanismRenderer.FluidType.STILL);
            }

            public double getLevel() {
                return ((TileEntityReactorController)GuiReactorHeat.this.tile).getPlasmaTemp();
            }

            public double getScaledLevel() {
                return Math.min(1.0, this.getLevel() / 5.0E8);
            }

            public ITextComponent getText() {
                return GeneratorsLang.REACTOR_PLASMA.translate(new Object[]{MekanismUtils.getTemperatureDisplay((double)this.getLevel(), (UnitDisplayUtils.TemperatureUnit)UnitDisplayUtils.TemperatureUnit.KELVIN, (boolean)true)});
            }
        }, GaugeType.STANDARD, (IGuiWrapper)this, 7, 50));
        this.addButton((Widget)new GuiProgress(() -> ((TileEntityReactorController)this.tile).getPlasmaTemp() > ((TileEntityReactorController)this.tile).getCaseTemp() ? 1.0 : 0.0, ProgressType.SMALL_RIGHT, (IGuiWrapper)this, 29, 76));
        this.addButton((Widget)new GuiNumberGauge(new GuiNumberGauge.INumberInfoHandler(){

            public TextureAtlasSprite getIcon() {
                return MekanismRenderer.getBaseFluidTexture((Fluid)Fluids.field_204547_b, (MekanismRenderer.FluidType)MekanismRenderer.FluidType.STILL);
            }

            public double getLevel() {
                return ((TileEntityReactorController)GuiReactorHeat.this.tile).getCaseTemp();
            }

            public double getScaledLevel() {
                return Math.min(1.0, this.getLevel() / 5.0E8);
            }

            public ITextComponent getText() {
                return GeneratorsLang.REACTOR_CASE.translate(new Object[]{MekanismUtils.getTemperatureDisplay((double)this.getLevel(), (UnitDisplayUtils.TemperatureUnit)UnitDisplayUtils.TemperatureUnit.KELVIN, (boolean)true)});
            }
        }, GaugeType.STANDARD, (IGuiWrapper)this, 61, 50));
        this.addButton((Widget)new GuiProgress(() -> ((TileEntityReactorController)this.tile).getCaseTemp() > 0.0 ? 1.0 : 0.0, ProgressType.SMALL_RIGHT, (IGuiWrapper)this, 83, 61));
        this.addButton((Widget)new GuiProgress(() -> ((TileEntityReactorController)this.tile).getCaseTemp() > 0.0 && !((TileEntityReactorController)this.tile).waterTank.isEmpty() && ((TileEntityReactorController)this.tile).steamTank.getStored() < ((TileEntityReactorController)this.tile).steamTank.getCapacity() ? 1.0 : 0.0, ProgressType.SMALL_RIGHT, (IGuiWrapper)this, 83, 91));
        this.addButton((Widget)new GuiFluidGauge(() -> ((TileEntityReactorController)this.tile).waterTank, () -> ((TileEntityReactorController)this.tile).getFluidTanks(null), GaugeType.SMALL, (IGuiWrapper)this, 115, 84));
        this.addButton((Widget)new GuiGasGauge(() -> ((TileEntityReactorController)this.tile).steamTank, () -> ((TileEntityReactorController)this.tile).getGasTanks(null), GaugeType.SMALL, (IGuiWrapper)this, 151, 84));
        this.addButton((Widget)new GuiEnergyGauge((IEnergyContainer)((TileEntityReactorController)this.tile).energyContainer, GaugeType.SMALL, (IGuiWrapper)this, 115, 46));
        this.addButton((Widget)new GuiReactorTab((IGuiWrapper)this, (TileEntityReactorController)this.tile, GuiReactorTab.ReactorTab.FUEL));
        this.addButton((Widget)new GuiReactorTab((IGuiWrapper)this, (TileEntityReactorController)this.tile, GuiReactorTab.ReactorTab.STAT));
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        this.drawString(((TileEntityReactorController)this.tile).getName(), 46, 6, 0x404040);
    }
}

