/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.common;

import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import slimeknights.mantle.item.BlockTooltipItem;

public interface IRegisterUtil {
    public String getModId();

    default public ResourceLocation getResource(String name) {
        return new ResourceLocation(this.getModId(), name);
    }

    default public <I extends T, T extends IForgeRegistryEntry<T>> I register(IForgeRegistry<T> registry, I thing, String name) {
        return this.register(registry, thing, this.getResource(name));
    }

    default public <I extends T, T extends IForgeRegistryEntry<T>> I register(IForgeRegistry<T> registry, I thing, ResourceLocation location) {
        thing.setRegistryName(location);
        registry.register(thing);
        return thing;
    }

    default public BlockItem registerBlockItem(IForgeRegistry<Item> registry, Block block) {
        BlockTooltipItem itemBlock = new BlockTooltipItem(block, new Item.Properties());
        return this.register(registry, itemBlock, block.getRegistryName());
    }

    default public BlockItem registerBlockItem(IForgeRegistry<Item> registry, Block block, ItemGroup group) {
        BlockTooltipItem itemBlock = new BlockTooltipItem(block, new Item.Properties().func_200916_a(group));
        return this.register(registry, itemBlock, block.getRegistryName());
    }

    default public <T extends BlockItem> T registerBlockItem(IForgeRegistry<Item> registry, T itemBlock) {
        return this.register(registry, itemBlock, itemBlock.func_179223_d().getRegistryName());
    }

    default public <T extends TileEntity> TileEntityType<T> registerTE(IForgeRegistry<TileEntityType<?>> registry, Supplier<T> constructor, String name, Block ... validBlocks) {
        TileEntityType type = TileEntityType.Builder.func_223042_a(constructor, (Block[])validBlocks).func_206865_a(null);
        return this.register(registry, type, name);
    }

    default public <B extends Block> List<B> registerBlocks(IForgeRegistry<Block> registry, Function<Block.Properties, B> constructor, IStringSerializable[] variants, Block.Properties props, String baseName) {
        return Arrays.stream(variants).map(s -> (Block)this.register(registry, (IForgeRegistryEntry)constructor.apply(props), baseName + "_" + s.func_176610_l())).collect(Collectors.toList());
    }

    default public List<BlockItem> registerBlockItems(IForgeRegistry<Item> registry, List<? extends Block> blocks) {
        return blocks.stream().map(block -> this.registerBlockItem(registry, (BlockItem)block)).collect(Collectors.toList());
    }

    default public List<BlockItem> registerBlockItems(IForgeRegistry<Item> registry, List<? extends Block> blocks, ItemGroup group) {
        return blocks.stream().map(block -> this.registerBlockItem(registry, (Block)block, group)).collect(Collectors.toList());
    }

    default public <T extends BlockItem> List<T> registerBlockItems(IForgeRegistry<Item> registry, List<? extends Block> blocks, Function<Block, T> constructor) {
        return blocks.stream().map(block -> this.registerBlockItem(registry, (BlockItem)constructor.apply((Block)block))).collect(Collectors.toList());
    }
}

