/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import com.google.common.collect.Streams;
import java.util.Collections;
import java.util.Set;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.CubeCoordinateIterator;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.border.WorldBorder;

public interface ICollisionReader
extends IBlockReader {
    public WorldBorder func_175723_af();

    @Nullable
    public IBlockReader func_225522_c_(int var1, int var2);

    default public boolean func_195585_a(@Nullable Entity entity, VoxelShape voxelShape) {
        return true;
    }

    default public boolean func_226663_a_(BlockState blockState, BlockPos blockPos, ISelectionContext iSelectionContext) {
        VoxelShape voxelShape = blockState.func_215685_b(this, blockPos, iSelectionContext);
        return voxelShape.func_197766_b() || this.func_195585_a(null, voxelShape.func_197751_a(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p()));
    }

    default public boolean func_226668_i_(Entity entity) {
        return this.func_195585_a(entity, VoxelShapes.func_197881_a(entity.func_174813_aQ()));
    }

    default public boolean func_226664_a_(AxisAlignedBB axisAlignedBB) {
        return this.func_226662_a_(null, axisAlignedBB, Collections.emptySet());
    }

    default public boolean func_226669_j_(Entity entity) {
        return this.func_226662_a_(entity, entity.func_174813_aQ(), Collections.emptySet());
    }

    default public boolean func_226665_a__(Entity entity, AxisAlignedBB axisAlignedBB) {
        return this.func_226662_a_(entity, axisAlignedBB, Collections.emptySet());
    }

    default public boolean func_226662_a_(@Nullable Entity entity, AxisAlignedBB axisAlignedBB, Set<Entity> set) {
        return this.func_226667_c_(entity, axisAlignedBB, set).allMatch(VoxelShape::func_197766_b);
    }

    default public Stream<VoxelShape> func_223439_a(@Nullable Entity entity, AxisAlignedBB axisAlignedBB, Set<Entity> set) {
        return Stream.empty();
    }

    default public Stream<VoxelShape> func_226667_c_(@Nullable Entity entity, AxisAlignedBB axisAlignedBB, Set<Entity> set) {
        return Streams.concat((Stream[])new Stream[]{this.func_226666_b_(entity, axisAlignedBB), this.func_223439_a(entity, axisAlignedBB, set)});
    }

    default public Stream<VoxelShape> func_226666_b_(final @Nullable Entity entity, AxisAlignedBB axisAlignedBB) {
        int n = MathHelper.func_76128_c(axisAlignedBB.field_72340_a - 1.0E-7) - 1;
        \u2603 = MathHelper.func_76128_c(axisAlignedBB.field_72336_d + 1.0E-7) + 1;
        \u2603 = MathHelper.func_76128_c(axisAlignedBB.field_72338_b - 1.0E-7) - 1;
        \u2603 = MathHelper.func_76128_c(axisAlignedBB.field_72337_e + 1.0E-7) + 1;
        \u2603 = MathHelper.func_76128_c(axisAlignedBB.field_72339_c - 1.0E-7) - 1;
        \u2603 = MathHelper.func_76128_c(axisAlignedBB.field_72334_f + 1.0E-7) + 1;
        final ISelectionContext \u26032 = entity == null ? ISelectionContext.func_216377_a() : ISelectionContext.func_216374_a(entity);
        final CubeCoordinateIterator \u26033 = new CubeCoordinateIterator(n, \u2603, \u2603, \u2603, \u2603, \u2603);
        final BlockPos.Mutable \u26034 = new BlockPos.Mutable();
        final VoxelShape \u26035 = VoxelShapes.func_197881_a(axisAlignedBB);
        return StreamSupport.stream(new Spliterators.AbstractSpliterator<VoxelShape>(Long.MAX_VALUE, 1280){
            boolean field_226670_a_;
            {
                super(l, n);
                this.field_226670_a_ = entity == null;
            }

            @Override
            public boolean tryAdvance(Consumer<? super VoxelShape> consumer) {
                int \u260332;
                int \u260322;
                if (!this.field_226670_a_) {
                    this.field_226670_a_ = true;
                    VoxelShape voxelShape = ICollisionReader.this.func_175723_af().func_222521_a();
                    \u260322 = VoxelShapes.func_197879_c(voxelShape, VoxelShapes.func_197881_a(entity.func_174813_aQ().func_186664_h(1.0E-7)), IBooleanFunction.field_223238_i_) ? 1 : 0;
                    \u260332 = VoxelShapes.func_197879_c(voxelShape, VoxelShapes.func_197881_a(entity.func_174813_aQ().func_186662_g(1.0E-7)), IBooleanFunction.field_223238_i_) ? 1 : 0;
                    if (\u260322 == 0 && \u260332 != 0) {
                        consumer.accept(voxelShape);
                        return true;
                    }
                }
                while (\u26033.func_218301_a()) {
                    int \u260342 = \u26033.func_218304_b();
                    \u260322 = \u26033.func_218302_c();
                    \u260332 = \u26033.func_218303_d();
                    int \u260352 = \u26033.func_223473_e();
                    if (\u260352 == 3 || (\u2603 = ICollisionReader.this.func_225522_c_(\u2603 = \u260342 >> 4, \u2603 = \u260332 >> 4)) == null) continue;
                    \u26034.func_181079_c(\u260342, \u260322, \u260332);
                    BlockState \u26036 = \u2603.func_180495_p(\u26034);
                    if (\u260352 == 1 && !\u26036.func_215704_f() || \u260352 == 2 && \u26036.func_177230_c() != Blocks.field_196603_bb || !VoxelShapes.func_197879_c(\u26035, \u2603 = (\u2603 = \u26036.func_215685_b(ICollisionReader.this, \u26034, \u26032)).func_197751_a(\u260342, \u260322, \u260332), IBooleanFunction.field_223238_i_)) continue;
                    consumer.accept(\u2603);
                    return true;
                }
                return false;
            }
        }, false);
    }
}

