/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.passive.horse;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.SoundType;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.passive.horse.DonkeyEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.HorseArmorItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class HorseEntity
extends AbstractHorseEntity {
    private static final UUID field_184786_bD = UUID.fromString("556E1665-8B10-40C8-8F9D-CF9B1667F295");
    private static final DataParameter<Integer> field_184789_bG = EntityDataManager.func_187226_a(HorseEntity.class, DataSerializers.field_187192_b);
    private static final String[] field_110268_bz = new String[]{"textures/entity/horse/horse_white.png", "textures/entity/horse/horse_creamy.png", "textures/entity/horse/horse_chestnut.png", "textures/entity/horse/horse_brown.png", "textures/entity/horse/horse_black.png", "textures/entity/horse/horse_gray.png", "textures/entity/horse/horse_darkbrown.png"};
    private static final String[] field_110269_bA = new String[]{"hwh", "hcr", "hch", "hbr", "hbl", "hgr", "hdb"};
    private static final String[] field_110291_bB = new String[]{null, "textures/entity/horse/horse_markings_white.png", "textures/entity/horse/horse_markings_whitefield.png", "textures/entity/horse/horse_markings_whitedots.png", "textures/entity/horse/horse_markings_blackdots.png"};
    private static final String[] field_110292_bC = new String[]{"", "wo_", "wmo", "wdo", "bdo"};
    @Nullable
    private String field_110286_bQ;
    private final String[] field_110280_bR = new String[2];

    public HorseEntity(EntityType<? extends HorseEntity> entityType, World world) {
        super((EntityType<? extends AbstractHorseEntity>)entityType, world);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_184789_bG, 0);
    }

    @Override
    public void func_213281_b(CompoundNBT compoundNBT) {
        super.func_213281_b(compoundNBT);
        compoundNBT.func_74768_a("Variant", this.func_110202_bQ());
        if (!this.field_110296_bG.func_70301_a(1).func_190926_b()) {
            compoundNBT.func_218657_a("ArmorItem", this.field_110296_bG.func_70301_a(1).func_77955_b(new CompoundNBT()));
        }
    }

    public ItemStack func_213803_dV() {
        return this.func_184582_a(EquipmentSlotType.CHEST);
    }

    private void func_213805_k(ItemStack itemStack) {
        this.func_184201_a(EquipmentSlotType.CHEST, itemStack);
        this.func_184642_a(EquipmentSlotType.CHEST, 0.0f);
    }

    @Override
    public void func_70037_a(CompoundNBT compoundNBT) {
        super.func_70037_a(compoundNBT);
        this.func_110235_q(compoundNBT.func_74762_e("Variant"));
        if (compoundNBT.func_150297_b("ArmorItem", 10) && !(\u2603 = ItemStack.func_199557_a(compoundNBT.func_74775_l("ArmorItem"))).func_190926_b() && this.func_190682_f(\u2603)) {
            this.field_110296_bG.func_70299_a(1, \u2603);
        }
        this.func_110232_cE();
    }

    public void func_110235_q(int n) {
        this.field_70180_af.func_187227_b(field_184789_bG, n);
        this.func_110230_cF();
    }

    public int func_110202_bQ() {
        return this.field_70180_af.func_187225_a(field_184789_bG);
    }

    private void func_110230_cF() {
        this.field_110286_bQ = null;
    }

    @Override
    protected void func_110232_cE() {
        super.func_110232_cE();
        this.func_213804_l(this.field_110296_bG.func_70301_a(1));
        this.func_184642_a(EquipmentSlotType.CHEST, 0.0f);
    }

    private void func_213804_l(ItemStack itemStack) {
        this.func_213805_k(itemStack);
        if (!this.field_70170_p.field_72995_K) {
            this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_188479_b(field_184786_bD);
            if (this.func_190682_f(itemStack) && (\u2603 = ((HorseArmorItem)itemStack.func_77973_b()).func_219977_e()) != 0) {
                this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111121_a(new AttributeModifier(field_184786_bD, "Horse armor bonus", (double)\u2603, AttributeModifier.Operation.ADDITION).func_111168_a(false));
            }
        }
    }

    @Override
    public void func_76316_a(IInventory iInventory) {
        ItemStack itemStack = this.func_213803_dV();
        super.func_76316_a(iInventory);
        \u2603 = this.func_213803_dV();
        if (this.field_70173_aa > 20 && this.func_190682_f(\u2603) && itemStack != \u2603) {
            this.func_184185_a(SoundEvents.field_187702_cm, 0.5f, 1.0f);
        }
    }

    @Override
    protected void func_190680_a(SoundType soundType) {
        super.func_190680_a(soundType);
        if (this.field_70146_Z.nextInt(10) == 0) {
            this.func_184185_a(SoundEvents.field_187705_cn, soundType.func_185843_a() * 0.6f, soundType.func_185847_b());
        }
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(this.func_110267_cL());
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(this.func_110203_cN());
        this.func_110148_a(field_110271_bv).func_111128_a(this.func_110245_cM());
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K && this.field_70180_af.func_187223_a()) {
            this.field_70180_af.func_187230_e();
            this.func_110230_cF();
        }
    }

    @Override
    protected SoundEvent func_184639_G() {
        super.func_184639_G();
        return SoundEvents.field_187696_ck;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        super.func_184615_bR();
        return SoundEvents.field_187708_co;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        super.func_184601_bQ(damageSource);
        return SoundEvents.field_187717_cr;
    }

    @Override
    protected SoundEvent func_184785_dv() {
        super.func_184785_dv();
        return SoundEvents.field_187699_cl;
    }

    @Override
    public boolean func_184645_a(PlayerEntity playerEntity, Hand hand) {
        ItemStack itemStack = playerEntity.func_184586_b(hand);
        boolean bl = \u2603 = !itemStack.func_190926_b();
        if (\u2603 && itemStack.func_77973_b() instanceof SpawnEggItem) {
            return super.func_184645_a(playerEntity, hand);
        }
        if (!this.func_70631_g_()) {
            if (this.func_110248_bS() && playerEntity.func_226563_dT_()) {
                this.func_110199_f(playerEntity);
                return true;
            }
            if (this.func_184207_aI()) {
                return super.func_184645_a(playerEntity, hand);
            }
        }
        if (\u2603) {
            if (this.func_190678_b(playerEntity, itemStack)) {
                if (!playerEntity.field_71075_bZ.field_75098_d) {
                    itemStack.func_190918_g(1);
                }
                return true;
            }
            if (itemStack.func_111282_a(playerEntity, this, hand)) {
                return true;
            }
            if (!this.func_110248_bS()) {
                this.func_190687_dF();
                return true;
            }
            boolean bl2 = \u2603 = !this.func_70631_g_() && !this.func_110257_ck() && itemStack.func_77973_b() == Items.field_151141_av;
            if (this.func_190682_f(itemStack) || \u2603) {
                this.func_110199_f(playerEntity);
                return true;
            }
        }
        if (this.func_70631_g_()) {
            return super.func_184645_a(playerEntity, hand);
        }
        this.func_110237_h(playerEntity);
        return true;
    }

    @Override
    public boolean func_70878_b(AnimalEntity animalEntity) {
        if (animalEntity == this) {
            return false;
        }
        if (animalEntity instanceof DonkeyEntity || animalEntity instanceof HorseEntity) {
            return this.func_110200_cJ() && ((AbstractHorseEntity)animalEntity).func_110200_cJ();
        }
        return false;
    }

    @Override
    public AgeableEntity func_90011_a(AgeableEntity ageableEntity2) {
        AbstractHorseEntity \u26033;
        if (ageableEntity2 instanceof DonkeyEntity) {
            \u26033 = EntityType.field_200779_S.func_200721_a(this.field_70170_p);
        } else {
            AgeableEntity ageableEntity2;
            HorseEntity \u26032 = (HorseEntity)ageableEntity2;
            \u26033 = EntityType.field_200762_B.func_200721_a(this.field_70170_p);
            int \u26034 = this.field_70146_Z.nextInt(9);
            int \u26035 = \u26034 < 4 ? this.func_110202_bQ() & 0xFF : (\u26034 < 8 ? \u26032.func_110202_bQ() & 0xFF : this.field_70146_Z.nextInt(7));
            int \u26036 = this.field_70146_Z.nextInt(5);
            \u26035 = \u26036 < 2 ? (\u26035 |= this.func_110202_bQ() & 0xFF00) : (\u26036 < 4 ? (\u26035 |= \u26032.func_110202_bQ() & 0xFF00) : (\u26035 |= this.field_70146_Z.nextInt(5) << 8 & 0xFF00));
            ((HorseEntity)\u26033).func_110235_q(\u26035);
        }
        this.func_190681_a(ageableEntity2, \u26033);
        return \u26033;
    }

    @Override
    public boolean func_190677_dK() {
        return true;
    }

    @Override
    public boolean func_190682_f(ItemStack itemStack) {
        return itemStack.func_77973_b() instanceof HorseArmorItem;
    }

    @Override
    @Nullable
    public ILivingEntityData func_213386_a(IWorld iWorld, DifficultyInstance difficultyInstance, SpawnReason spawnReason, @Nullable ILivingEntityData \u260322, @Nullable CompoundNBT compoundNBT) {
        ILivingEntityData \u260322;
        int n;
        if (\u260322 instanceof HorseData) {
            n = ((HorseData)\u260322).field_190885_a;
        } else {
            n = this.field_70146_Z.nextInt(7);
            \u260322 = new HorseData(n);
        }
        this.func_110235_q(n | this.field_70146_Z.nextInt(5) << 8);
        return super.func_213386_a(iWorld, difficultyInstance, spawnReason, \u260322, compoundNBT);
    }

    public static class HorseData
    extends AgeableEntity.AgeableData {
        public final int field_190885_a;

        public HorseData(int n) {
            this.field_190885_a = n;
        }
    }
}

