/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.forms;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import thelm.jaopca.api.forms.IForm;
import thelm.jaopca.api.forms.IFormRequest;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.api.modules.IModule;
import thelm.jaopca.modules.ModuleHandler;

public class FormRequest
implements IFormRequest {
    private final IModule module;
    private final List<IForm> forms;
    private boolean grouped = false;

    public FormRequest(IModule module, IForm ... forms) {
        this.module = Objects.requireNonNull(module);
        this.forms = (List)Arrays.stream((Object[])Objects.requireNonNull(forms)).filter(Objects::nonNull).filter(form -> form.getModule() == module).map(IForm::lock).collect(ImmutableList.toImmutableList());
        for (IForm form2 : this.forms) {
            form2.setRequest(this);
        }
    }

    @Override
    public IModule getModule() {
        return this.module;
    }

    @Override
    public List<IForm> getForms() {
        return this.forms;
    }

    @Override
    public boolean isGrouped() {
        return this.grouped;
    }

    @Override
    public IFormRequest setGrouped(boolean grouped) {
        this.grouped = grouped;
        return this;
    }

    @Override
    public boolean isMaterialGroupValid(IMaterial material) {
        return !ModuleHandler.getModuleData(this.module).getRejectedMaterials().contains(material) && this.forms.stream().filter(form -> !form.skipGroupedCheck()).anyMatch(form -> form.isMaterialValid(material));
    }
}

