/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.data;

import com.google.common.collect.TreeMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.resources.IResourcePack;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.resources.VanillaPack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.packs.ModFileResourcePack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DataCollector {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int TAGS_PATH_LENGTH = "tags/".length();
    private static final int RECIPES_PATH_LENGTH = "recipes/".length();
    private static final int LOOT_TABLES_PATH_LENGTH = "loot_tables/".length();
    private static final int ADVANCEMENTS_PATH_LENGTH = "advancements/".length();
    private static final int JSON_EXTENSION_LENGTH = ".json".length();
    private static final List<Supplier<IResourcePack>> RESOURCE_PACK_SUPPLIERS = new ArrayList<Supplier<IResourcePack>>();
    private static final List<IResourcePack> RESOURCE_PACKS = new ArrayList<IResourcePack>();
    private static final TreeMultimap<String, ResourceLocation> DEFINED_TAGS = TreeMultimap.create();
    private static final TreeSet<ResourceLocation> DEFINED_RECIPES = new TreeSet();
    private static final TreeSet<ResourceLocation> DEFINED_LOOT_TABLES = new TreeSet();
    private static final TreeSet<ResourceLocation> DEFINED_ADVANCEMENTS = new TreeSet();

    private DataCollector() {
    }

    public static void collectData() {
        String path;
        String namespace;
        DEFINED_TAGS.clear();
        DEFINED_RECIPES.clear();
        DEFINED_ADVANCEMENTS.clear();
        if (RESOURCE_PACKS.isEmpty()) {
            RESOURCE_PACKS.add((IResourcePack)new VanillaPack(new String[]{"minecraft"}));
            ModList.get().getModFiles().stream().map(mf -> new ModFileResourcePack(mf.getFile())).forEach(RESOURCE_PACKS::add);
            for (Supplier supplier : RESOURCE_PACK_SUPPLIERS) {
                RESOURCE_PACKS.add((IResourcePack)supplier.get());
            }
        }
        for (ResourceLocation resourceLocation : DataCollector.getAllDataResourceLocations("tags", name -> name.endsWith(".json"))) {
            namespace = resourceLocation.func_110624_b();
            path = resourceLocation.func_110623_a();
            String[] split = (path = path.substring(TAGS_PATH_LENGTH, path.length() - JSON_EXTENSION_LENGTH)).split("/", 2);
            if (split.length == 2) {
                String type = split[0];
                path = split[1];
                DEFINED_TAGS.put((Object)type, (Object)new ResourceLocation(namespace, path));
                continue;
            }
            LOGGER.error("Tag {} in namespace {} has no type", (Object)path, (Object)namespace);
        }
        LOGGER.info("Found {} unique defined tags", (Object)DEFINED_TAGS.size());
        for (ResourceLocation resourceLocation : DataCollector.getAllDataResourceLocations("recipes", name -> name.endsWith(".json"))) {
            namespace = resourceLocation.func_110624_b();
            path = resourceLocation.func_110623_a();
            if (path.equals("recipes/_constants.json") || path.equals("recipes/_factories.json")) continue;
            path = path.substring(RECIPES_PATH_LENGTH, path.length() - JSON_EXTENSION_LENGTH);
            DEFINED_RECIPES.add(new ResourceLocation(namespace, path));
        }
        LOGGER.info("Found {} unique defined recipes", (Object)DEFINED_RECIPES.size());
        for (ResourceLocation resourceLocation : DataCollector.getAllDataResourceLocations("loot_tables", name -> name.endsWith(".json"))) {
            namespace = resourceLocation.func_110624_b();
            path = resourceLocation.func_110623_a();
            path = path.substring(LOOT_TABLES_PATH_LENGTH, path.length() - JSON_EXTENSION_LENGTH);
            DEFINED_LOOT_TABLES.add(new ResourceLocation(namespace, path));
        }
        LOGGER.info("Found {} unique defined loot tables", (Object)DEFINED_LOOT_TABLES.size());
        for (ResourceLocation resourceLocation : DataCollector.getAllDataResourceLocations("advancements", name -> name.endsWith(".json"))) {
            namespace = resourceLocation.func_110624_b();
            path = resourceLocation.func_110623_a();
            path = path.substring(ADVANCEMENTS_PATH_LENGTH, path.length() - JSON_EXTENSION_LENGTH);
            DEFINED_ADVANCEMENTS.add(new ResourceLocation(namespace, path));
        }
        LOGGER.info("Found {} unique defined advancements", (Object)DEFINED_ADVANCEMENTS.size());
    }

    public static Set<ResourceLocation> getDefinedTags(String type) {
        return DEFINED_TAGS.get((Object)type);
    }

    public static Set<ResourceLocation> getDefinedRecipes() {
        return DEFINED_RECIPES;
    }

    public static Set<ResourceLocation> getDefinedLootTables() {
        return DEFINED_LOOT_TABLES;
    }

    public static Set<ResourceLocation> getDefinedAdvancements() {
        return DEFINED_ADVANCEMENTS;
    }

    static Collection<ResourceLocation> getAllDataResourceLocations(String pathIn, Predicate<String> filter) {
        TreeSet<ResourceLocation> set = new TreeSet<ResourceLocation>();
        for (IResourcePack resourcePack : RESOURCE_PACKS) {
            for (String namespace : resourcePack.func_195759_a(ResourcePackType.SERVER_DATA)) {
                set.addAll(resourcePack.func_225637_a_(ResourcePackType.SERVER_DATA, namespace, pathIn, Integer.MAX_VALUE, filter));
            }
        }
        return set;
    }
}

