/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.uselessmod;

import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.api.materials.MaterialType;
import thelm.jaopca.api.modules.IModule;
import thelm.jaopca.api.modules.IModuleData;
import thelm.jaopca.api.modules.JAOPCAModule;
import thelm.jaopca.compat.uselessmod.UselessModHelper;
import thelm.jaopca.utils.MiscHelper;

@JAOPCAModule(modDependencies={"uselessmod"})
public class UselessModModule
implements IModule {
    private static final Set<String> BLACKLIST = new TreeSet<String>(Arrays.asList("gold", "iron", "super_useless", "useless"));

    @Override
    public String getName() {
        return "uselessmod";
    }

    @Override
    public Multimap<Integer, String> getModuleDependencies() {
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        builder.put((Object)0, (Object)"dusts");
        return builder.build();
    }

    @Override
    public Set<MaterialType> getMaterialTypes() {
        return EnumSet.of(MaterialType.INGOT);
    }

    @Override
    public Set<String> getDefaultMaterialBlacklist() {
        return BLACKLIST;
    }

    @Override
    public void onCommonSetup(IModuleData moduleData, FMLCommonSetupEvent event) {
        UselessModHelper helper = UselessModHelper.INSTANCE;
        MiscHelper miscHelper = MiscHelper.INSTANCE;
        for (IMaterial material : moduleData.getMaterials()) {
            ResourceLocation oreLocation = miscHelper.getTagLocation("ores", material.getName());
            ResourceLocation dustLocation = miscHelper.getTagLocation("dusts", material.getName());
            helper.registerCrushingRecipe(new ResourceLocation("jaopca", "uselessmod.ore_to_dust." + material.getName()), oreLocation, dustLocation, 2, 2.3f, 200);
        }
    }

    static {
        if (ModList.get().isLoaded("silents_mechanisms")) {
            Collections.addAll(BLACKLIST, "aluminum", "bismuth", "copper", "lead", "nickel", "platinum", "silver", "tin", "uranium", "zinc");
        }
    }
}

