/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.silentsmechanisms;

import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;
import thelm.jaopca.api.config.IDynamicSpecConfig;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.api.materials.MaterialType;
import thelm.jaopca.api.modules.IModule;
import thelm.jaopca.api.modules.IModuleData;
import thelm.jaopca.api.modules.JAOPCAModule;
import thelm.jaopca.compat.silentsmechanisms.SilentsMechanismsHelper;
import thelm.jaopca.utils.ApiImpl;
import thelm.jaopca.utils.MiscHelper;

@JAOPCAModule(modDependencies={"silents_mechanisms"})
public class SilentsMechanismsNonIngotModule
implements IModule {
    private static final Set<String> BLACKLIST = new TreeSet<String>(Arrays.asList("coal", "diamond", "dimensional", "emerald", "lapis", "quartz", "redstone"));
    private Map<IMaterial, IDynamicSpecConfig> configs;

    @Override
    public String getName() {
        return "silents_mechanisms_noningot";
    }

    @Override
    public Set<MaterialType> getMaterialTypes() {
        return EnumSet.of(MaterialType.GEM, MaterialType.CRYSTAL, MaterialType.DUST);
    }

    @Override
    public Set<String> getDefaultMaterialBlacklist() {
        return BLACKLIST;
    }

    @Override
    public void defineMaterialConfig(IModuleData moduleData, Map<IMaterial, IDynamicSpecConfig> configs) {
        this.configs = configs;
    }

    @Override
    public void onCommonSetup(IModuleData moduleData, FMLCommonSetupEvent event) {
        ApiImpl api = ApiImpl.INSTANCE;
        SilentsMechanismsHelper helper = SilentsMechanismsHelper.INSTANCE;
        MiscHelper miscHelper = MiscHelper.INSTANCE;
        for (IMaterial material : moduleData.getMaterials()) {
            ResourceLocation oreLocation = miscHelper.getTagLocation("ores", material.getName());
            ResourceLocation materialLocation = miscHelper.getTagLocation(material.getType().getFormName(), material.getName());
            if (material.getType() != MaterialType.DUST) {
                IDynamicSpecConfig config = this.configs.get(material);
                String configByproduct = config.getDefinedString("silents_mechanisms.byproduct", "minecraft:cobblestone", s -> ForgeRegistries.ITEMS.containsKey(new ResourceLocation(s)), "The byproduct material to output in Silent's Mechanisms' Crusher.");
                Item byproduct = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(configByproduct));
                helper.registerCrushingRecipe(new ResourceLocation("jaopca", "silents_mechanisms.ore_to_material." + material.getName()), oreLocation, 400, materialLocation, 2, materialLocation, 1, Float.valueOf(0.1f), byproduct, 1, Float.valueOf(0.1f));
                continue;
            }
            helper.registerCrushingRecipe(new ResourceLocation("jaopca", "silents_mechanisms.ore_to_material." + material.getName()), oreLocation, 400, materialLocation, 5);
        }
    }

    static {
        if (ModList.get().isLoaded("silentgems")) {
            Collections.addAll(BLACKLIST, "agate", "alexandrite", "amazonite", "amber", "amethyst", "ametrine", "ammolite", "apatite", "aquamarine", "benitoite", "black_diamond", "carnelian", "cats_eye", "chaos", "chrysoprase", "citrine", "coral", "euclase", "fluorite", "garnet", "green_sapphire", "heliodor", "iolite", "jade", "jasper", "kunzite", "kyanite", "lepidoite", "malachite", "moldavite", "moonstone", "morganite", "onyx", "opal", "pearl", "peridot", "phosphophyllite", "pyrope", "rose_quartz", "ruby", "sapphire", "sodalite", "spinel", "sunstone", "tanzanite", "teklite", "topaz", "turquoise", "yellow_diamond", "zircon");
        }
    }
}

