/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.crafttweaker;

import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.impl.item.MCItemStack;
import com.blamejared.crafttweaker.impl.tag.MCTag;
import java.util.TreeMap;
import net.minecraft.item.ItemStack;
import org.openzen.zencode.java.ZenCodeType;
import thelm.jaopca.api.forms.IForm;
import thelm.jaopca.api.materials.MaterialType;
import thelm.jaopca.compat.crafttweaker.Material;
import thelm.jaopca.compat.crafttweaker.MaterialForm;
import thelm.jaopca.utils.MiscHelper;

@ZenRegister
@ZenCodeType.Name(value="mods.jaopca.Form")
public class Form {
    private static final TreeMap<IForm, Form> FORM_WRAPPERS = new TreeMap();
    private final IForm form;

    public static Form getFormWrapper(IForm form) {
        return FORM_WRAPPERS.computeIfAbsent(form, Form::new);
    }

    private Form(IForm form) {
        this.form = form;
    }

    public IForm getInternal() {
        return this.form;
    }

    @ZenCodeType.Getter(value="name")
    public String getName() {
        return this.form.getName();
    }

    @ZenCodeType.Getter(value="type")
    public String getType() {
        return this.form.getType().getName();
    }

    @ZenCodeType.Getter(value="secondaryName")
    public String getSecondaryName() {
        return this.form.getSecondaryName();
    }

    @ZenCodeType.Getter(value="materialTypes")
    public String[] getMaterialTypes() {
        return (String[])this.form.getMaterialTypes().stream().map(MaterialType::getName).toArray(String[]::new);
    }

    @ZenCodeType.Method
    public Material[] getMaterials() {
        return (Material[])this.form.getMaterials().stream().map(Material::getMaterialWrapper).toArray(Material[]::new);
    }

    @ZenCodeType.Method
    public boolean containsMaterial(Material material) {
        return this.form.getMaterials().contains(material.getInternal());
    }

    @ZenCodeType.Method
    public MCTag getTag(String suffix) {
        return new MCTag(MiscHelper.INSTANCE.getTagLocation(this.form.getSecondaryName(), suffix));
    }

    @ZenCodeType.Method
    public IItemStack getItemStack(String suffix, int count) {
        MiscHelper helper = MiscHelper.INSTANCE;
        ItemStack stack = helper.getItemStack(helper.getTagLocation(this.form.getSecondaryName(), suffix), count);
        return new MCItemStack(stack);
    }

    @ZenCodeType.Method
    public IItemStack getItemStack(String suffix) {
        return this.getItemStack(suffix, 1);
    }

    @ZenCodeType.Method
    public MaterialForm getMaterialForm(Material material) {
        if (!this.containsMaterial(material)) {
            return null;
        }
        return MaterialForm.getMaterialFormWrapper(this.form, material.getInternal());
    }

    @ZenCodeType.Method
    public MaterialForm[] getMaterialForms() {
        return (MaterialForm[])this.form.getMaterials().stream().map(m -> MaterialForm.getMaterialFormWrapper(this.form, m)).toArray(MaterialForm[]::new);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Form)) {
            return false;
        }
        Form other = (Form)obj;
        return this.form == other.form;
    }

    public int hashCode() {
        return this.form.hashCode() + 5;
    }
}

