/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.client.events;

import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.resources.ReloadListener;
import net.minecraft.fluid.Fluid;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IPackFinder;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.resources.IResourceManager;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import thelm.jaopca.api.blocks.IMaterialFormBlock;
import thelm.jaopca.api.fluids.IMaterialFormFluid;
import thelm.jaopca.api.fluids.IMaterialFormFluidBlock;
import thelm.jaopca.blocks.BlockFormType;
import thelm.jaopca.client.colors.ColorHandler;
import thelm.jaopca.client.models.ModelHandler;
import thelm.jaopca.client.resources.ResourceInjector;
import thelm.jaopca.fluids.FluidFormType;
import thelm.jaopca.localization.LocalizationRepoHandler;
import thelm.jaopca.modules.ModuleHandler;

public class ClientEventHandler {
    public static final ClientEventHandler INSTANCE = new ClientEventHandler();

    public static ClientEventHandler getInstance() {
        return INSTANCE;
    }

    public void onConstruct() {
        DeferredWorkQueue.runLater(() -> {});
    }

    @SubscribeEvent
    public void onClientSetup(FMLClientSetupEvent event) {
        Minecraft mc = (Minecraft)event.getMinecraftSupplier().get();
        mc.func_195548_H().func_198982_a((IPackFinder)ResourceInjector.PackFinder.INSTANCE);
        LocalizationRepoHandler.setup();
        ((IReloadableResourceManager)mc.func_195551_G()).func_219534_a((IFutureReloadListener)new ReloadListener<Object>(){

            protected Object func_212854_a_(IResourceManager resourceManager, IProfiler profiler) {
                return null;
            }

            protected void func_212853_a_(Object splashList, IResourceManager resourceManager, IProfiler profiler) {
                LocalizationRepoHandler.reload();
            }
        });
        DeferredWorkQueue.runLater(() -> ModuleHandler.onClientSetup(event));
        for (IMaterialFormBlock block : BlockFormType.getBlocks()) {
            RenderTypeLookup.setRenderLayer((Block)block.asBlock(), (RenderType)RenderType.func_228645_f_());
        }
        for (IMaterialFormFluid fluid : FluidFormType.getFluids()) {
            RenderTypeLookup.setRenderLayer((Fluid)fluid.asFluid(), (RenderType)RenderType.func_228645_f_());
        }
        for (IMaterialFormFluidBlock fluidBlock : FluidFormType.getFluidBlocks()) {
            RenderTypeLookup.setRenderLayer((Block)fluidBlock.asBlock(), (RenderType)RenderType.func_228645_f_());
        }
    }

    @SubscribeEvent
    public void onModelRegistry(ModelRegistryEvent event) {
        ModelHandler.registerModels();
    }

    @SubscribeEvent
    public void onModelBake(ModelBakeEvent event) {
        ModelHandler.remapModels(event);
    }

    @SubscribeEvent
    public void onColorHandler(ColorHandlerEvent.Item event) {
        ColorHandler.setup(event);
    }

    @SubscribeEvent
    public void onTextureStitchPre(TextureStitchEvent.Pre event) {
    }
}

