/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.client.colors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Vector4f;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.Tag;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.event.ColorHandlerEvent;
import thelm.jaopca.api.blocks.IMaterialFormBlock;
import thelm.jaopca.api.blocks.IMaterialFormBlockItem;
import thelm.jaopca.api.fluids.IMaterialFormBucketItem;
import thelm.jaopca.api.fluids.IMaterialFormFluidBlock;
import thelm.jaopca.api.items.IMaterialFormItem;
import thelm.jaopca.api.materialforms.IMaterialForm;
import thelm.jaopca.blocks.BlockFormType;
import thelm.jaopca.config.ConfigHandler;
import thelm.jaopca.fluids.FluidFormType;
import thelm.jaopca.items.ItemFormType;

public class ColorHandler {
    public static final IBlockColor BLOCK_COLOR = (state, world, pos, tintIndex) -> {
        Block block;
        if (tintIndex == 0 && (block = state.func_177230_c()) instanceof IMaterialForm) {
            IMaterialForm materialForm = (IMaterialForm)block;
            return materialForm.getMaterial().getColor();
        }
        return -1;
    };
    public static final IItemColor ITEM_COLOR = (stack, tintIndex) -> {
        Item item;
        if ((tintIndex == 0 || tintIndex == 2) && (item = stack.func_77973_b()) instanceof IMaterialForm) {
            IMaterialForm materialForm = (IMaterialForm)item;
            return materialForm.getMaterial().getColor();
        }
        return -1;
    };

    public static void setup(ColorHandlerEvent.Item event) {
        BlockColors blockColors = event.getBlockColors();
        ItemColors itemColors = event.getItemColors();
        for (IMaterialFormBlock block : BlockFormType.getBlocks()) {
            blockColors.func_186722_a(BLOCK_COLOR, new Block[]{block.asBlock()});
        }
        for (IMaterialFormBlockItem blockItem : BlockFormType.getBlockItems()) {
            itemColors.func_199877_a(ITEM_COLOR, new IItemProvider[]{blockItem.asBlockItem()});
        }
        for (IMaterialFormItem item : ItemFormType.getItems()) {
            itemColors.func_199877_a(ITEM_COLOR, new IItemProvider[]{item.asItem()});
        }
        for (IMaterialFormFluidBlock fluidBlock : FluidFormType.getFluidBlocks()) {
            blockColors.func_186722_a(BLOCK_COLOR, new Block[]{fluidBlock.asBlock()});
        }
        for (IMaterialFormBucketItem bucketItem : FluidFormType.getBucketItems()) {
            itemColors.func_199877_a(ITEM_COLOR, new IItemProvider[]{bucketItem.asItem()});
        }
    }

    public static int getAverageColor(Tag<Item> tag) {
        Vector4f color = ColorHandler.weightedAverageColor(tag.func_199885_a(), ConfigHandler.gammaValue);
        return ColorHandler.toColorInt(color);
    }

    public static Vector4f weightedAverageColor(Collection<Item> items, double gammaValue) {
        if (items.isEmpty()) {
            return new Vector4f(1.0f, 1.0f, 1.0f, 0.0f);
        }
        List<Vector4f> colors = items.stream().map(ItemStack::new).map(stack -> ColorHandler.weightedAverageColor(stack, gammaValue)).collect(Collectors.toList());
        return ColorHandler.weightedAverageColor(colors, gammaValue);
    }

    public static Vector4f weightedAverageColor(ItemStack stack, double gammaValue) {
        List<BakedQuad> quads = ColorHandler.getBakedQuads(stack);
        if (quads.isEmpty()) {
            return new Vector4f(1.0f, 1.0f, 1.0f, 0.0f);
        }
        ArrayList<Vector4f> colors = new ArrayList<Vector4f>();
        for (BakedQuad quad : quads) {
            Vector4f color = ColorHandler.weightedAverageColor(quad.func_187508_a(), gammaValue);
            color = ColorHandler.tintColor(color, ColorHandler.getTint(stack, quad));
            colors.add(color);
        }
        return ColorHandler.weightedAverageColor(colors, gammaValue);
    }

    public static Vector4f weightedAverageColor(TextureAtlasSprite texture, double gammaValue) {
        int width = texture.func_94211_a();
        int height = texture.func_94216_b();
        int frameCount = texture.func_110970_k();
        if (width <= 0 || height <= 0 || frameCount <= 0) {
            return new Vector4f(1.0f, 1.0f, 1.0f, 0.0f);
        }
        ArrayList<Vector4f> colors = new ArrayList<Vector4f>();
        for (int frameIndex = 0; frameIndex < frameCount; ++frameIndex) {
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    int color = texture.getPixelRGBA(frameIndex, x, y);
                    colors.add(ColorHandler.toColorTuple(color));
                }
            }
        }
        return ColorHandler.weightedAverageColor(colors, gammaValue);
    }

    public static Vector4f weightedAverageColor(List<Vector4f> colors, double gammaValue) {
        if (colors.isEmpty()) {
            return new Vector4f(1.0f, 1.0f, 1.0f, 0.0f);
        }
        double r = 0.0;
        double g = 0.0;
        double b = 0.0;
        double totalWeight = 0.0;
        if (gammaValue == 0.0) {
            r = 1.0;
            g = 1.0;
            b = 1.0;
            for (Vector4f color : colors) {
                double weight = color.func_195915_d();
                totalWeight += weight;
                r *= (double)color.func_195910_a() * weight;
                g *= (double)color.func_195913_b() * weight;
                b *= (double)color.func_195914_c() * weight;
            }
            r = Math.pow(r, 1.0 / totalWeight);
            g = Math.pow(g, 1.0 / totalWeight);
            b = Math.pow(b, 1.0 / totalWeight);
        } else {
            for (Vector4f color : colors) {
                double weight = color.func_195915_d();
                totalWeight += weight;
                r += Math.pow(color.func_195910_a(), gammaValue) * weight;
                g += Math.pow(color.func_195913_b(), gammaValue) * weight;
                b += Math.pow(color.func_195914_c(), gammaValue) * weight;
            }
            r = Math.pow(r / totalWeight, 1.0 / gammaValue);
            g = Math.pow(g / totalWeight, 1.0 / gammaValue);
            b = Math.pow(b / totalWeight, 1.0 / gammaValue);
        }
        return new Vector4f((float)MathHelper.func_151237_a((double)r, (double)0.0, (double)1.0), (float)MathHelper.func_151237_a((double)g, (double)0.0, (double)1.0), (float)MathHelper.func_151237_a((double)b, (double)0.0, (double)1.0), (float)MathHelper.func_151237_a((double)(totalWeight / (double)colors.size()), (double)0.0, (double)1.0));
    }

    public static Vector4f toColorTuple(int color) {
        return new Vector4f((float)(color & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 24 & 0xFF) / 255.0f);
    }

    public static Vector4f tintColor(Vector4f color, int tint) {
        return new Vector4f(color.func_195910_a() * (float)(tint >> 16 & 0xFF) / 255.0f, color.func_195913_b() * (float)(tint >> 8 & 0xFF) / 255.0f, color.func_195914_c() * (float)(tint & 0xFF) / 255.0f, color.func_195915_d());
    }

    public static int toColorInt(Vector4f color) {
        int ret = 0;
        ret |= (Math.round(MathHelper.func_76131_a((float)(color.func_195910_a() * 255.0f), (float)0.0f, (float)255.0f)) & 0xFF) << 16;
        ret |= (Math.round(MathHelper.func_76131_a((float)(color.func_195913_b() * 255.0f), (float)0.0f, (float)255.0f)) & 0xFF) << 8;
        return ret |= Math.round(MathHelper.func_76131_a((float)(color.func_195914_c() * 255.0f), (float)0.0f, (float)255.0f)) & 0xFF;
    }

    public static List<BakedQuad> getBakedQuads(ItemStack stack) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        IBakedModel model = Minecraft.func_71410_x().func_175599_af().func_184393_a(stack, null, null);
        model.func_200117_a(null, null, new Random(0L)).stream().filter(quad -> quad.func_178210_d() == Direction.SOUTH).forEach(quads::add);
        for (Direction facing : Direction.values()) {
            model.func_200117_a(null, facing, new Random(0L)).stream().filter(quad -> quad.func_178210_d() == Direction.SOUTH).forEach(quads::add);
        }
        return quads;
    }

    public static int getTint(ItemStack stack, BakedQuad quad) {
        return Minecraft.func_71410_x().getItemColors().func_186728_a(stack, quad.func_178211_c());
    }
}

