/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpoles.blocks;

import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.core.ForgeMod;
import com.endertech.minecraft.mods.adpoles.blocks.Pole;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class PoweredPole
extends Pole {
    public static final BooleanProperty POWERED = BooleanProperty.func_177716_a((String)"powered");

    public PoweredPole(ForgeMod mod, UnitConfig config, Pole.Properties<?> props) {
        super(mod, config, props);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new IProperty[]{POWERED});
    }

    @Override
    public Direction getSlideDirection(World world, BlockPos pos) {
        if (this.isPoweredPole((IBlockReader)world, pos)) {
            return Direction.UP;
        }
        return super.getSlideDirection(world, pos);
    }

    public boolean canConnectRedstone(BlockState state, IBlockReader world, BlockPos pos, @Nullable Direction side) {
        if (side != null) {
            switch (side) {
                case UP: 
                case DOWN: {
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isPoweredPole(IBlockReader world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        return this.isSamePole(world, pos) && (Boolean)state.func_177229_b((IProperty)POWERED) != false;
    }

    public void updatePoweredState(World world, BlockPos pos, BlockState state) {
        boolean powered;
        BlockState newstate;
        if (this.isServerSide((IWorldReader)world) && state != (newstate = (BlockState)state.func_206870_a((IProperty)POWERED, (Comparable)Boolean.valueOf(powered = this.findPowerSource(world, pos))))) {
            world.func_175656_a(pos, newstate);
        }
    }

    protected boolean findPowerSource(World world, BlockPos startPos) {
        for (Direction facing : new Direction[]{Direction.DOWN, Direction.UP}) {
            BlockPos pos = startPos;
            while (this.isSamePole((IBlockReader)world, pos)) {
                boolean found = world.func_175709_b(pos.func_177972_a(facing), facing.func_176734_d());
                if (found) {
                    return true;
                }
                pos = pos.func_177972_a(facing);
            }
        }
        return false;
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        this.updatePoweredState(world, pos, state);
    }

    public void func_220082_b(BlockState state, World world, BlockPos pos, BlockState oldState, boolean isMoving) {
        this.updatePoweredState(world, pos, state);
    }

    public int getLightValue(BlockState state, IBlockReader world, BlockPos pos) {
        return this.isPoweredPole(world, pos) ? 1 : super.getLightValue(state, world, pos);
    }
}

