/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpoles;

import com.endertech.minecraft.forge.core.ForgeMod;
import com.endertech.minecraft.forge.items.ForgeBlockItem;
import com.endertech.minecraft.mods.adpoles.entities.Holder;
import com.endertech.minecraft.mods.adpoles.init.Poles;
import com.endertech.minecraft.mods.adpoles.network.HolderMsg;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.common.Mod;

@Mod(value="adpoles")
public class AdPoles
extends ForgeMod {
    public static final String ID = "adpoles";
    public static final String NAME = "To the Bat Poles!";
    private static AdPoles instance;
    private static Poles poles;

    public static AdPoles getInstance() {
        return instance;
    }

    public static Poles getPoles() {
        return poles;
    }

    public AdPoles() {
        instance = this;
        poles = new Poles(this);
    }

    public String getId() {
        return ID;
    }

    public void commonInit() {
        this.registerNetMessage(HolderMsg::new);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientInit() {
        this.registerEntityRender(Holder.type, Holder.Renderer::new);
    }

    public void commonPostInit() {
    }

    public void commonConfigInit(ForgeMod.ConfigValueBuilder value) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientConfigInit(ForgeMod.ConfigValueBuilder value) {
        Holder.switchToThirdPersonView = value.comment("Enables automatic switching to a third-person view while holding the pole").define("switchToThirdPersonView", true);
        Holder.basicSlidingControl = value.comment("Switches between one key 'moveForward' and two keys 'moveForward/moveBackward' controls").define("basicSlidingControl", false);
    }

    public void registerBlocks() {
        for (Poles.BuildIn poletype : Poles.BuildIn.values()) {
            if (!poletype.register) continue;
            this.registerBlock((Block)poletype.getPole());
        }
    }

    public void registerItems() {
        Item.Properties props = new Item.Properties().func_200916_a(ItemGroup.field_78029_e);
        for (Poles.BuildIn value : Poles.BuildIn.values()) {
            if (!value.register) continue;
            this.registerBlockItem((BlockItem)new ForgeBlockItem((Block)value.getPole(), props));
        }
    }

    public void registerEntities() {
        Holder.type = this.registerEntity("holder", EntityType.Builder.func_220319_a((EntityClassification)EntityClassification.MISC).func_220321_a(0.5f, 0.5f).setUpdateInterval(20).setTrackingRange(32).setShouldReceiveVelocityUpdates(true).func_200706_c().setCustomClientFactory(Holder::new));
    }

    public void registerTiles() {
    }
}

