/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedpipes.network.pipe.item;

import com.raoulvdberge.refinedpipes.RefinedPipes;
import com.raoulvdberge.refinedpipes.message.ItemTransportMessage;
import com.raoulvdberge.refinedpipes.network.NetworkManager;
import com.raoulvdberge.refinedpipes.network.item.ItemNetwork;
import com.raoulvdberge.refinedpipes.network.pipe.Pipe;
import com.raoulvdberge.refinedpipes.network.pipe.item.ItemPipeType;
import com.raoulvdberge.refinedpipes.network.pipe.transport.ItemTransport;
import com.raoulvdberge.refinedpipes.network.pipe.transport.ItemTransportProps;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ItemPipe
extends Pipe {
    public static final ResourceLocation ID = new ResourceLocation("refinedpipes", "item");
    private final List<ItemTransport> transports = new ArrayList<ItemTransport>();
    private final List<ItemTransport> transportsToAdd = new ArrayList<ItemTransport>();
    private final List<ItemTransport> transportsToRemove = new ArrayList<ItemTransport>();
    private final ItemPipeType type;

    public ItemPipe(World world, BlockPos pos, ItemPipeType type) {
        super(world, pos);
        this.type = type;
    }

    @Override
    public void update() {
        super.update();
        this.transports.addAll(this.transportsToAdd);
        this.transports.removeAll(this.transportsToRemove);
        if (!this.transportsToAdd.isEmpty() || !this.transportsToRemove.isEmpty()) {
            NetworkManager.get(this.world).func_76185_a();
            this.sendTransportUpdate();
        }
        if (!this.transports.isEmpty()) {
            NetworkManager.get(this.world).func_76185_a();
        }
        this.transportsToAdd.clear();
        this.transportsToRemove.clear();
        if (this.transports.removeIf(t -> t.update(this.network, this))) {
            NetworkManager.get(this.world).func_76185_a();
        }
    }

    public List<ItemTransport> getTransports() {
        return this.transports;
    }

    public void addTransport(ItemTransport transport) {
        this.transportsToAdd.add(transport);
    }

    public void removeTransport(ItemTransport transport) {
        this.transportsToRemove.add(transport);
    }

    public void sendTransportUpdate() {
        ArrayList<ItemTransportProps> props = new ArrayList<ItemTransportProps>();
        for (ItemTransport transport : this.transports) {
            props.add(transport.createProps(this));
        }
        RefinedPipes.NETWORK.sendInArea(this.world, this.pos, 32, new ItemTransportMessage(this.pos, props));
    }

    @Override
    public CompoundNBT writeToNbt(CompoundNBT tag) {
        tag = super.writeToNbt(tag);
        tag.func_74768_a("type", this.type.ordinal());
        ListNBT transports = new ListNBT();
        for (ItemTransport transport : this.transports) {
            transports.add((Object)transport.writeToNbt(new CompoundNBT()));
        }
        tag.func_218657_a("transports", (INBT)transports);
        return tag;
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public ResourceLocation getNetworkType() {
        return ItemNetwork.TYPE;
    }

    public int getMaxTicksInPipe() {
        return this.type.getMaxTicksInPipe();
    }
}

