/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedpipes.network.pipe.attachment;

import com.raoulvdberge.refinedpipes.network.pipe.attachment.Attachment;
import com.raoulvdberge.refinedpipes.network.pipe.attachment.AttachmentManager;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;

public class ClientAttachmentManager
implements AttachmentManager {
    private final ResourceLocation[] attachmentState = new ResourceLocation[Direction.values().length];
    private final Map<Direction, ItemStack> pickBlocks = new HashMap<Direction, ItemStack>();

    @Override
    public ResourceLocation[] getState() {
        return this.attachmentState;
    }

    @Override
    public boolean hasAttachment(Direction dir) {
        return this.attachmentState[dir.ordinal()] != null;
    }

    @Override
    public void openAttachmentContainer(Direction dir, ServerPlayerEntity player) {
        throw new RuntimeException("Server-side only");
    }

    @Override
    @Nonnull
    public ItemStack getPickBlock(Direction dir) {
        return this.pickBlocks.getOrDefault(dir, ItemStack.field_190927_a);
    }

    @Override
    @Nullable
    public Attachment getAttachment(Direction dir) {
        throw new RuntimeException("Server-side only");
    }

    @Override
    public void writeUpdate(CompoundNBT tag) {
        throw new RuntimeException("Server-side only");
    }

    @Override
    public void readUpdate(CompoundNBT tag) {
        this.pickBlocks.clear();
        for (Direction dir : Direction.values()) {
            String attachmentKey = "attch_" + dir.ordinal();
            String pickBlockKey = "pb_" + dir.ordinal();
            if (tag.func_74764_b(attachmentKey) || tag.func_74764_b(pickBlockKey)) {
                this.pickBlocks.put(dir, ItemStack.func_199557_a((CompoundNBT)tag.func_74775_l(pickBlockKey)));
                this.attachmentState[dir.ordinal()] = new ResourceLocation(tag.func_74779_i(attachmentKey));
                continue;
            }
            this.attachmentState[dir.ordinal()] = null;
        }
    }
}

